package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 第三方调用活动平台的接口，需要保证path和参数一致。
 * todo 后期优化为自动转发
 * @author jiaxz
 * @since 2023-03-03
 *
 */
@AdvancedFeignClient(qualifier = "remoteGalaxyBackendService")
public interface RemoteGalaxyBackendService{

    /**
     * 该功能目前只支持转发固定path，反例：path中带占位符
     * @param path 活动平台后端接口path
     * @param args 活动平台所需接口所需参数
     * @return 返回参数由galaxy决定，可直接返回。保证双端数据交互一致性
     */
    String callGalaxyController(String path, Object... args);


}
