package cn.com.duiba.galaxy.api.model.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 商品类型枚举
 *
 * @author zhangdaqing
 * @Date 2022/10/29 18:21
 * @desc 积分商城的商品类型枚举，
 **/
@Getter
public enum ItemTypeEnum {

    OBJECT(1, "object", "实物"),
    COUPONS(2, "coupon", "优惠券"),
    COUPONS_KM(3, "coupon", "卡密"),
    DUIBA_VIRTUAL(4, "duibaVirtual", "卡券直充"),
    VIRTUAL(5, "virtual", "商家充值"),
    CREDITS(6, "increase-credits", "积分"),
    ALIPAY(7, "alipay", "支付宝"),
    PHONE_BILL(8, "phonebill", "话费"),
    QB(9, "qb", "Q币"),
    ;


    /**
     * 编码
     */
    private Integer code;

    /**
     * 类型
     */
    private String type;

    /**
     * 描述
     */
    private String desc;


    ItemTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static ItemTypeEnum getByType(String type) {
        return Stream.of(ItemTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(OBJECT);
    }
}
