/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.controller;

import cn.com.duiba.developer.center.api.domain.dto.appextra.AppConfigDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppExtraService;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.devops.web.api.RemoteAmiyaProjectService;
import cn.com.duiba.devops.web.model.common.PageRes;
import cn.com.duiba.devops.web.param.amiya.ProjectSearchDto;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.CommonBackendManager;
import cn.com.duiba.galaxy.console.manager.FileUploadManager;
import cn.com.duiba.galaxy.console.manager.ProjectManager;
import cn.com.duiba.galaxy.console.manager.RegionManager;
import cn.com.duiba.galaxy.console.model.param.CheckParam;
import cn.com.duiba.galaxy.console.model.param.IdentityQueryParam;
import cn.com.duiba.galaxy.console.model.param.project.DayanQueryParam;
import cn.com.duiba.galaxy.console.model.vo.EnumVo;
import cn.com.duiba.galaxy.console.model.vo.IdentityVo;
import cn.com.duiba.galaxy.console.model.vo.RegionVo;
import cn.com.duiba.galaxy.console.model.vo.SsoUserVo;
import cn.com.duiba.galaxy.console.model.vo.project.DayanSearchVo;
import cn.com.duiba.galaxy.console.model.vo.project.PageDayanProjectVo;
import cn.com.duiba.galaxy.console.model.vo.project.SimpleAppInfoVo;
import cn.com.duiba.galaxy.core.activity.CheckMode;
import cn.com.duiba.galaxy.core.activity.Configable;
import cn.com.duiba.galaxy.core.enums.ConfigType;
import cn.com.duiba.galaxy.core.enums.PlaywayTypeEnum;
import cn.com.duiba.galaxy.sdk.base.JsonResult;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/common"})
public class CommonBackendController {
    private static final Logger log = LoggerFactory.getLogger(CommonBackendController.class);
    @Resource
    private FileUploadManager fileUploadManager;
    @Resource
    private ProjectManager projectManager;
    @Resource
    private RegionManager regionManager;
    @Resource
    private RemoteAppService remoteAppService;
    @Resource
    private RemoteAmiyaProjectService remoteAmiyaProjectService;
    @Resource
    private RemoteAppExtraService remoteAppExtraServiceNew;
    @Resource
    private RemoteAdminService remoteAdminService;
    @Autowired
    private CommonBackendManager commonBackendManager;

    @GetMapping(name="\u67e5\u8be2\u73a9\u6cd5\u7c7b\u578b", value={"/listPlayways"})
    public List<JSONObject> getAttributesByConditions() {
        return Arrays.stream(PlaywayTypeEnum.values()).map(value -> new JSONObject().fluentPut(value.getCode().toString(), (Object)value.getDesc())).collect(Collectors.toList());
    }

    @GetMapping(name="\u67e5\u8be2appIds\u4fe1\u606f", value={"/listSimpleAppInfo"})
    public JsonResult<List<SimpleAppInfoVo>> listSimpleAppInfo(String appIds) {
        ArrayList appInfoVos = new ArrayList();
        if (StringUtils.isBlank((CharSequence)appIds)) {
            return JsonResult.success(appInfoVos);
        }
        List appIdList = Arrays.stream(appIds.split(",")).map(Long::valueOf).collect(Collectors.toList());
        List apps = this.remoteAppService.findByIds(appIdList);
        apps.forEach(u -> {
            SimpleAppInfoVo simpleAppInfoVo = SimpleAppInfoVo.builder().appId(u.getId()).appName(u.getName()).appKey(u.getAppKey()).build();
            appInfoVos.add(simpleAppInfoVo);
        });
        return JsonResult.success(appInfoVos);
    }

    @GetMapping(name="\u901a\u8fc7appName(\u524d\u6a21\u7cca)\u67e5\u8be2app\u5e94\u7528\u4fe1\u606f", value={"/listSimpleAppInfoByNameLike"})
    public JsonResult<List<SimpleAppInfoVo>> listSimpleAppInfoByNameLike(String appName) {
        ArrayList appInfoVos = new ArrayList();
        if (StringUtils.isBlank((CharSequence)appName)) {
            return JsonResult.success(appInfoVos);
        }
        DubboResult simpleDtoResult = this.remoteAppService.findAppNameByNameLike(appName);
        List simpleDtoList = (List)simpleDtoResult.getResult();
        simpleDtoList.forEach(u -> {
            SimpleAppInfoVo simpleAppInfoVo = SimpleAppInfoVo.builder().appId(u.getId()).appName(u.getName()).appKey(u.getAppKey()).build();
            appInfoVos.add(simpleAppInfoVo);
        });
        return JsonResult.success(appInfoVos);
    }

    @PostMapping(value={"/uploadFile"})
    public JsonResult<String> uploadFile(@RequestParam MultipartFile file) {
        try {
            return JsonResult.success((Object)this.fileUploadManager.uploadFile(file));
        }
        catch (Exception e) {
            throw new BizRuntimeException((BizError)PlatformConsoleErrorEnum.FILE_UNKNOWN_ERROR, (Throwable)e);
        }
    }

    @GetMapping(value={"/getEnumByName"})
    public JsonResult<List<EnumVo>> getEnumByName(@RequestParam(required=false) String name) {
        return JsonResult.success(this.commonBackendManager.getEnumByName(name));
    }

    @GetMapping(name="\u67e5\u8be2\u7701\u4efd\u548c\u57ce\u5e02\u4fe1\u606f", value={"/getProvinceAndCity"})
    public JsonResult<List<RegionVo>> getProvinceAndCity(HttpServletResponse response) {
        return JsonResult.success(this.regionManager.getProvinceAndCity());
    }

    @PostMapping(name="\u67e5\u8be2\u5927\u96c1\u9879\u76ee", value={"/searchDayan"})
    public JsonResult<PageDayanProjectVo> searchDayan(@Validated @RequestBody DayanQueryParam param) {
        ProjectSearchDto projectSearchDto = (ProjectSearchDto)BeanUtil.copyProperties((Object)((Object)param), ProjectSearchDto.class, (String[])new String[0]);
        PageRes amiyaSimpleProjectResPageRes = this.remoteAmiyaProjectService.pageList(projectSearchDto);
        PageDayanProjectVo pageDayanProjectVo = new PageDayanProjectVo();
        pageDayanProjectVo.setTotalCount(amiyaSimpleProjectResPageRes.getTotal());
        pageDayanProjectVo.setList(BeanUtil.copyToList((Collection)amiyaSimpleProjectResPageRes.getData(), DayanSearchVo.class));
        return JsonResult.success((Object)pageDayanProjectVo);
    }

    @GetMapping(name="\u67e5\u8be2sso\u7528\u6237\u4fe1\u606f", value={"/searchSsoUser"})
    public JsonResult<List<SsoUserVo>> searchSsoUser(String name) {
        ArrayList ssoUserVos = new ArrayList();
        if (StringUtils.isBlank((CharSequence)name)) {
            return JsonResult.success(ssoUserVos);
        }
        List adminDtos = this.remoteAdminService.findByNameLike(name);
        return JsonResult.success((Object)BeanUtil.copyToList((Collection)adminDtos, SsoUserVo.class));
    }

    @GetMapping(name="\u67e5\u8be2sso\u7528\u6237\u4fe1\u606f", value={"/batchFindAdminInfoByIds"})
    public JsonResult<List<SsoUserVo>> batchFindAdminInfoByIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return JsonResult.success();
        }
        List list = Arrays.stream(ids.split(",")).map(Long::valueOf).collect(Collectors.toList());
        List adminInfoDtos = this.remoteAdminService.batchFindAdminInfoByIds(list);
        return JsonResult.success((Object)BeanUtil.copyToList((Collection)adminInfoDtos, SsoUserVo.class));
    }

    @PostMapping(name="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u8eab\u4efd\u4fe1\u606f", value={"/listAllIdentityByType"})
    public JsonResult<IdentityVo> listAllIdentityByType(@Validated @RequestBody IdentityQueryParam param) {
        return JsonResult.success((Object)this.projectManager.listAllIdentityByType(param.getType(), param.getAppId()));
    }

    @PostMapping(name="\u6821\u9a8c", value={"/check"})
    public JsonResult<String> check(@Validated @RequestBody CheckParam param) {
        Configable configable = ConfigType.ofCode((Integer)param.getType()).getCreator().create(null, JSONObject.toJSONString((Object)param.getContent()));
        Conditions.expectNotNull((Object)configable, (BizError)PlatformConsoleErrorEnum.CONFIG_CHECK_ERROR);
        CheckMode checkMode = new CheckMode(param.getMode() == 1, true);
        configable.findConfigErrors(checkMode);
        return JsonResult.success();
    }

    @GetMapping(value={"/generateID"})
    public JsonResult<String> generateID(@RequestParam Integer type) {
        ConfigType configType = ConfigType.ofCode((Integer)type);
        Conditions.expectNotNull((Object)configType, (BizError)PlatformConsoleErrorEnum.INVALID_TYPE);
        return JsonResult.success((Object)configType.getCreator().generateId());
    }

    @GetMapping(value={"/getNavProgram"})
    public JsonResult<String> getNavProgram(@NotNull(message="appId\u5fc5\u4f20") @NotNull(message="appId\u5fc5\u4f20") Long appId) {
        return JsonResult.success(Optional.ofNullable(this.remoteAppExtraServiceNew.findAppConfigDto(appId)).map(DubboResult::getResult).map(AppConfigDto::getNavProgram).orElse(null));
    }
}

