/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.controller;

import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/link/{userId}")
public class ConsoleWebSocketController {
    private static final Logger log = LoggerFactory.getLogger(ConsoleWebSocketController.class);
    private String userId;

    @OnOpen
    public void onOpen(@PathParam(value="userId") String userId) {
        this.userId = userId;
        log.info("\u65b0\u8fde\u63a5\uff1a{}", (Object)userId);
    }

    @OnClose
    public void onClose() {
        log.info("\u8fde\u63a5\uff1a{} \u5173\u95ed", (Object)this.userId);
    }

    @OnMessage
    public void onMessage(String message) {
        log.info("\u6536\u5230\u7528\u6237{}\u7684\u6d88\u606f{}", (Object)this.userId, (Object)message);
    }

    @OnError
    public void onError(Throwable error) {
        log.info("\u7528\u6237userId\u4e3a\uff1a{}\u7684\u8fde\u63a5\u53d1\u9001\u9519\u8bef", (Object)this.userId);
        error.printStackTrace();
    }
}

