/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.controller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.galaxy.basic.enums.OptionTypeEnum;
import cn.com.duiba.galaxy.basic.enums.PrototypeTypeEnum;
import cn.com.duiba.galaxy.basic.model.entity.ProjectEntity;
import cn.com.duiba.galaxy.basic.model.entity.PrototypeEntity;
import cn.com.duiba.galaxy.basic.model.jsonfield.PlayAttributesJson;
import cn.com.duiba.galaxy.basic.model.jsonfield.StrategyJson;
import cn.com.duiba.galaxy.basic.service.ProjectService;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.ProjectManager;
import cn.com.duiba.galaxy.console.model.param.project.AccountConfigUpdateParam;
import cn.com.duiba.galaxy.console.model.param.project.OpenbsUpdateParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectCopyParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectNewParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectQueryParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectUpdateParam;
import cn.com.duiba.galaxy.console.model.param.project.SimpleProjectParam;
import cn.com.duiba.galaxy.console.model.param.project.UpdateAppIdParam;
import cn.com.duiba.galaxy.console.model.param.valid.GroupByProjectType;
import cn.com.duiba.galaxy.console.model.vo.project.PageProjectVo;
import cn.com.duiba.galaxy.console.model.vo.project.ProjectQueryVo;
import cn.com.duiba.galaxy.console.model.vo.project.ProjectSimpleVo;
import cn.com.duiba.galaxy.core.util.ValidateUtils;
import cn.com.duiba.galaxy.sdk.base.JsonResult;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.groups.Default;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/project"})
public class ProjectConsoleController {
    private static final Logger log = LoggerFactory.getLogger(ProjectConsoleController.class);
    @Resource
    private ProjectManager projectManager;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private PrototypeService prototypeService;
    @Resource
    private RemoteAppService remoteAppService;

    @PostMapping(name="\u65b0\u5efa\u9879\u76ee", value={"/newProject"})
    public JsonResult<Boolean> newProject(@RequestBody ProjectNewParam param) throws BizException {
        Long prototypeId = param.getPrototypeId();
        PrototypeEntity prototypeEntity = (PrototypeEntity)this.prototypeService.getById((Serializable)prototypeId);
        if (Objects.equals(PrototypeTypeEnum.CUSTOMIZATION.getCode(), prototypeEntity.getPrototypeType())) {
            ValidateUtils.validate((Object)param, (Class[])new Class[]{Default.class, GroupByProjectType.Custom.class});
        } else {
            ValidateUtils.validate((Object)param, (Class[])new Class[]{Default.class, GroupByProjectType.Template.class});
        }
        Long projectId = this.projectManager.newProject(param);
        if (projectId == null) {
            return JsonResult.fail((BizError)PlatformConsoleErrorEnum.NEW_PROJECT_ERROR);
        }
        return JsonResult.success();
    }

    @GetMapping(name="\u67e5\u8be2\u9879\u76ee\u4fe1\u606f", value={"/getProject"})
    public JsonResult<ProjectQueryVo> getProject(@RequestParam Long projectId) {
        return JsonResult.success((Object)this.projectManager.getProjectByProjectId(projectId));
    }

    @PostMapping(name="\u66f4\u65b0\u9879\u76ee", value={"/update"})
    public JsonResult<String> update(@RequestBody ProjectUpdateParam param) throws BizException {
        Boolean result = this.projectManager.updateProject(param);
        if (Boolean.FALSE.equals(result)) {
            return JsonResult.fail((BizError)PlatformConsoleErrorEnum.SYSTEM_ERROR);
        }
        return JsonResult.success();
    }

    @GetMapping(name="\u83b7\u53d6\u7b80\u5355\u9879\u76ee", value={"/getSimpleProject"})
    public JsonResult<ProjectSimpleVo> getSimpleProject(Long projectId) {
        ProjectEntity projectEntity = (ProjectEntity)this.projectService.getById((Serializable)projectId);
        ProjectSimpleVo simpleVo = (ProjectSimpleVo)BeanUtil.copyProperties((Object)projectEntity, ProjectSimpleVo.class, (String[])new String[0]);
        return JsonResult.success((Object)simpleVo);
    }

    @PostMapping(name="\u66f4\u65b0\u9879\u76ee\u72b6\u6001", value={"/updateState"})
    public JsonResult<Boolean> updateState(@RequestBody SimpleProjectParam param) {
        return JsonResult.success((Object)this.projectManager.updateState(param.getId(), param.getState()));
    }

    @GetMapping(name="\u67e5\u8be2\u5217\u8868", value={"/list"})
    public JsonResult<PageProjectVo> list(ProjectQueryParam queryParam) {
        return JsonResult.success((Object)this.projectManager.listProjects(queryParam));
    }

    @PostMapping(name="\u5b9a\u5411appId", value={"/updateAppId"})
    public JsonResult<Boolean> updateAppId(@Validated @RequestBody UpdateAppIdParam param) {
        ProjectEntity projectEntity = (ProjectEntity)this.projectService.getById((Serializable)param.getId());
        Conditions.expectNotNull((Object)projectEntity, (BizError)PlatformConsoleErrorEnum.NULL_PROJECT);
        Long appId = param.getAppId();
        if (Objects.equals(appId, projectEntity.getAppId())) {
            return JsonResult.success();
        }
        AppSimpleDto appSimpleDto = this.remoteAppService.getSimpleAppNoCache(appId);
        Conditions.expectNotNull((Object)appSimpleDto, (BizError)PlatformConsoleErrorEnum.APP_NOT_FOUNT);
        PlayAttributesJson playAttributes = projectEntity.getPlayAttributes();
        List rules = playAttributes.getRules();
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            for (StrategyJson rule : rules) {
                List options;
                if (Boolean.FALSE.equals(rule.getStrategyEnable()) || !CollectionUtils.isNotEmpty((Collection)(options = rule.getOptions()))) continue;
                boolean haveProcurement = options.stream().anyMatch(u -> Objects.equals(u.getType(), OptionTypeEnum.PROCUREMENT.getCode()));
                Conditions.expectFalse((boolean)haveProcurement, (BizError)PlatformConsoleErrorEnum.NOT_ALLOW_UPDATE_APP);
            }
        }
        return JsonResult.success((Object)this.projectManager.updateAppId(param.getId(), param.getAppId()));
    }

    @PostMapping(value={"/updateOpenBs"})
    public JsonResult<Boolean> updateOpenBs(@Validated @RequestBody OpenbsUpdateParam param) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ProjectEntity::getId, (Object)param.getProjectId());
        updateWrapper.set(ProjectEntity::getOpenbs, (Object)param.getState());
        return JsonResult.success((Object)this.projectService.update((Wrapper)updateWrapper));
    }

    @GetMapping(value={"/getAccountSwitchConfig"})
    public JsonResult<Boolean> getAccountSwitchConfig(@RequestParam(value="projectId") String projectId) {
        return JsonResult.success();
    }

    @PostMapping(value={"/updateAccountSwitchConfig"})
    public JsonResult<Boolean> updateAccountSwitchConfig(@Validated @RequestBody AccountConfigUpdateParam param) {
        return JsonResult.success();
    }

    @GetMapping(value={"/getIndexUrl"})
    public JsonResult<String> getIndexUrl(@RequestParam Long projectId) {
        ProjectEntity projectEntity = (ProjectEntity)this.projectService.getById((Serializable)projectId);
        if (projectEntity == null || projectEntity.getAppId() == null) {
            return JsonResult.success();
        }
        return JsonResult.success((Object)this.projectManager.getIndexUrl(projectId, projectEntity.getAppId()));
    }

    @PostMapping(value={"/copyProject"})
    public JsonResult<Boolean> copyProject(@Validated @RequestBody ProjectCopyParam param) {
        return JsonResult.success((Object)this.projectManager.copyProject(param));
    }

    @GetMapping(value={"/getReadyCopyProject"})
    public JsonResult<ProjectQueryVo> getReadyCopyProject(Long projectId) {
        return JsonResult.success((Object)this.projectManager.getReadyCopyProject(projectId));
    }

    @GetMapping(value={"/getPreviewUrl"})
    public JsonResult<String> getPreviewUrl(Long projectId) {
        return JsonResult.success((Object)this.projectManager.getPreviewUrl(projectId));
    }
}

