/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.controller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.basic.service.PrototypeJarService;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.console.enums.EnvironmentTypeEnum;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.PrototypeManager;
import cn.com.duiba.galaxy.console.model.param.prototype.CrossPushPrototypeParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeQueryParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeSaveParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeUpdateParam;
import cn.com.duiba.galaxy.console.model.param.prototype.SimplePrototypeParam;
import cn.com.duiba.galaxy.console.model.param.prototype.UpdatePrototypeStateParam;
import cn.com.duiba.galaxy.console.model.param.valid.GroupByResponsibility;
import cn.com.duiba.galaxy.console.model.vo.PagePrototypeVo;
import cn.com.duiba.galaxy.console.model.vo.prototype.PrototypeVo;
import cn.com.duiba.galaxy.core.load.InstallJarService;
import cn.com.duiba.galaxy.core.util.ValidateUtils;
import cn.com.duiba.galaxy.sdk.base.JsonResult;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfOff;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.groups.Default;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/prototype"})
public class PrototypeController {
    private static final Logger log = LoggerFactory.getLogger(PrototypeController.class);
    @Autowired
    private PrototypeService prototypeService;
    @Resource
    private PrototypeManager prototypeManager;
    @Resource
    private InstallJarService installJarService;
    @Resource
    private PrototypeJarService prototypeJarService;

    @PostMapping(name="\u65b0\u5efa\u539f\u578b", value={"/newPrototype"})
    public JsonResult<Boolean> newPrototype(@Validated @RequestBody PrototypeSaveParam param) {
        return JsonResult.success((Object)this.prototypeManager.newPrototype(param));
    }

    @GetMapping(name="\u83b7\u53d6\u539f\u578b\u4fe1\u606f", value={"/getPrototype"})
    public JsonResult<PrototypeVo> getPrototype(SimplePrototypeParam param) {
        return JsonResult.success((Object)this.prototypeManager.getPrototype(param));
    }

    @PostMapping(name="\u66f4\u65b0\u539f\u578b", value={"/update"})
    public JsonResult<String> update(@RequestBody PrototypeUpdateParam param) throws Exception {
        String gitlab = param.getPlayAttributes().getJavaCode();
        Long prototypeId = param.getId();
        ValidateUtils.validate((Object)param, (Class[])new Class[]{GroupByResponsibility.Developer.class, Default.class});
        Future task = this.installJarService.submitJarTask(prototypeId, gitlab);
        Boolean result = this.prototypeManager.updatePrototype(param, task);
        if (Boolean.FALSE.equals(result)) {
            return JsonResult.fail((BizError)PlatformConsoleErrorEnum.SYSTEM_ERROR);
        }
        return JsonResult.success();
    }

    @PostMapping(name="\u66f4\u65b0\u539f\u578b\u72b6\u6001", value={"/updateState"})
    public JsonResult<Void> updateState(@Validated @RequestBody UpdatePrototypeStateParam param) {
        this.prototypeManager.updatePrototypeState(param.getPrototypeId(), param.getState());
        return JsonResult.success();
    }

    @GetMapping(name="\u539f\u578b\u5217\u8868(\u5206\u9875)", value={"/list"})
    public JsonResult<PagePrototypeVo> list(PrototypeQueryParam param) {
        Conditions.expectTrue((param != null ? 1 : 0) != 0, (BizError)PlatformConsoleErrorEnum.PARAM_ERROR);
        return JsonResult.success((Object)this.prototypeManager.listPrototypes(param));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(name="\u4e0a\u4f20\u539f\u578b\u6587\u4ef6", value={"/importConfig"})
    public JsonResult<JSONObject> importConfig(@RequestParam(value="file") MultipartFile file) throws BizException {
        try (InputStream in = file.getInputStream();){
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            String content = new String(bytes);
            JSONObject attribute = JSONObject.parseObject((String)content);
            JsonResult jsonResult = JsonResult.success((Object)attribute);
            return jsonResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @CsrfOff
    @GetMapping(value={"previewSkinOfIndex"})
    public void previewSkinOfIndex(@RequestParam Long prototypeId, HttpServletResponse response) {
        try (PrintWriter out = response.getWriter();){
            String html = this.prototypeManager.getSkinOfIndex(prototypeId);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/html");
            out.print(html);
        }
        catch (IOException e) {
            throw new BizRuntimeException((BizError)PlatformConsoleErrorEnum.SYSTEM_ERROR);
        }
    }

    @PostMapping(value={"pushPrototype"})
    public JsonResult<Boolean> pushPrototype(@Validated @RequestBody CrossPushPrototypeParam param, HttpServletRequest request) {
        EnvironmentTypeEnum environmentTypeEnum = EnvironmentTypeEnum.getEnvironmentTypeEnumByCode(param.getEnvironment());
        String targetUri = StringUtils.replace((String)request.getRequestURI(), (String)"pushPrototype", (String)"receiveAndSavePrototype");
        String url = String.format("http://galaxy.%s.com.cn%s", environmentTypeEnum.getDesc(), targetUri);
        param.setUrl(url);
        this.prototypeManager.pushPrototype(param);
        return JsonResult.success();
    }

    @CsrfOff
    @CanAccess
    @PostMapping(value={"receiveAndSavePrototype"})
    public JsonResult<Boolean> receiveAndSavePrototype(@RequestBody Map<String, String> map) {
        return JsonResult.success((Object)this.prototypeManager.receiveAndSavePrototype(map));
    }
}

