/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.galaxy.adapter.base.adapter.StockAdapter;
import cn.com.duiba.galaxy.adapter.base.dto.UpdateStockDto;
import cn.com.duiba.galaxy.adapter.base.enums.AdapterTypeEnum;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapter;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapterFactory;
import cn.com.duiba.galaxy.basic.enums.OptionTypeEnum;
import cn.com.duiba.galaxy.basic.enums.ProjectCreateSourceEnum;
import cn.com.duiba.galaxy.basic.enums.ProjectStateEnum;
import cn.com.duiba.galaxy.basic.enums.PrototypeTypeEnum;
import cn.com.duiba.galaxy.basic.model.entity.ProjectEntity;
import cn.com.duiba.galaxy.basic.model.entity.ProjectExtEntity;
import cn.com.duiba.galaxy.basic.model.entity.PrototypeEntity;
import cn.com.duiba.galaxy.basic.model.entity.SpEntity;
import cn.com.duiba.galaxy.basic.model.jsonfield.DayanProjectJson;
import cn.com.duiba.galaxy.basic.model.jsonfield.LayeredRuleJson;
import cn.com.duiba.galaxy.basic.model.jsonfield.OptionJson;
import cn.com.duiba.galaxy.basic.model.jsonfield.PlayAttributesJson;
import cn.com.duiba.galaxy.basic.model.jsonfield.StrategyJson;
import cn.com.duiba.galaxy.basic.service.ProjectExtService;
import cn.com.duiba.galaxy.basic.service.ProjectService;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.basic.service.SpService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.enums.ProjectUpdateButtonTypeEnum;
import cn.com.duiba.galaxy.console.enums.PrototypeStateEnum;
import cn.com.duiba.galaxy.console.manager.OptionManager;
import cn.com.duiba.galaxy.console.manager.ProjectManager;
import cn.com.duiba.galaxy.console.manager.SpManager;
import cn.com.duiba.galaxy.console.manager.SsoExtManager;
import cn.com.duiba.galaxy.console.model.param.LayeredRuleJsonParm;
import cn.com.duiba.galaxy.console.model.param.OperationalOptionParam;
import cn.com.duiba.galaxy.console.model.param.OptionJsonParam;
import cn.com.duiba.galaxy.console.model.param.PlayAttributesJsonParam;
import cn.com.duiba.galaxy.console.model.param.ProjectExtParam;
import cn.com.duiba.galaxy.console.model.param.StrategyJsonParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectCopyParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectNewParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectUpdateParam;
import cn.com.duiba.galaxy.console.model.param.valid.GroupByProjectCreateSource;
import cn.com.duiba.galaxy.console.model.param.valid.GroupByPrototypeType;
import cn.com.duiba.galaxy.console.model.param.valid.GroupByResponsibility;
import cn.com.duiba.galaxy.console.model.vo.PlayAttributesJsonVo;
import cn.com.duiba.galaxy.console.model.vo.ProjectExtraBaseVo;
import cn.com.duiba.galaxy.console.model.vo.SpVo;
import cn.com.duiba.galaxy.console.model.vo.StrategyJsonVo;
import cn.com.duiba.galaxy.console.model.vo.project.ProjectQueryVo;
import cn.com.duiba.galaxy.core.activity.BizProjectConfigMap;
import cn.com.duiba.galaxy.core.activity.CheckMode;
import cn.com.duiba.galaxy.core.activity.ClientBizProjectConfigMap;
import cn.com.duiba.galaxy.core.enums.PlatformCoreErrorEnum;
import cn.com.duiba.galaxy.core.factory.ObjectBuildFactory;
import cn.com.duiba.galaxy.core.load.custom.BizProject;
import cn.com.duiba.galaxy.core.util.ValidateUtils;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.groups.Default;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractProjectManagerImpl
implements ProjectManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractProjectManagerImpl.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private PrototypeService prototypeService;
    @Autowired
    private ProjectExtService projectExtService;
    @Autowired
    protected SpService spService;
    @Autowired
    protected SpManager spManager;
    @Autowired
    protected OptionManager optionManager;
    @Autowired
    private SsoExtManager ssoExtManager;
    @Autowired
    private ClientBizProjectConfigMap clientBizProjectConfigMap;
    @Autowired
    private GalaxyAdapterFactory<GalaxyAdapter> galaxyAdapterFactory;
    @Resource
    private TransactionTemplate transactionTemplate;

    @Override
    public Long newProject(ProjectNewParam param) {
        Long prototypeId = param.getPrototypeId();
        PrototypeEntity prototypeEntity = (PrototypeEntity)this.prototypeService.getById((Serializable)prototypeId);
        Conditions.expectNotNull((Object)prototypeEntity, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_FOUND);
        Conditions.expectTrue((boolean)Objects.equals(prototypeEntity.getState(), PrototypeStateEnum.ENABLED.getCode()), (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_ENABLED);
        ProjectEntity projectEntity = new ProjectEntity();
        PlayAttributesJson playAttributes = prototypeEntity.getPlayAttributes();
        if (playAttributes != null) {
            playAttributes.setJavaCode(null);
            playAttributes.setSkins(null);
            playAttributes.setCfUrl(null);
            projectEntity.setPlayAttributes(playAttributes);
        }
        if (prototypeEntity.getViewAttributes() != null) {
            projectEntity.setViewAttributes(prototypeEntity.getViewAttributes());
        }
        projectEntity.setProjectName(param.getProjectName());
        projectEntity.setPrototypeId(prototypeId);
        projectEntity.setState(ProjectStateEnum.INIT.getCode());
        Integer source = param.getSource();
        projectEntity.setOperator(Objects.equals(ProjectCreateSourceEnum.ACTIVITY_PLATFORM.getCode(), source) ? this.ssoExtManager.getAdminInfo().getName() : "system");
        projectEntity.setSource(source);
        projectEntity.setProd(param.getProd());
        Boolean execute = (Boolean)this.transactionTemplate.execute(t -> {
            try {
                boolean projectSave = this.projectService.save((Object)projectEntity);
                boolean projectExtraSave = true;
                boolean isPlatform = Objects.equals(source, ProjectCreateSourceEnum.ACTIVITY_PLATFORM.getCode());
                if (isPlatform && projectSave) {
                    ProjectExtEntity projectExtEntity = new ProjectExtEntity();
                    if (StringUtils.isNotBlank((CharSequence)param.getDayanProjectId()) && StringUtils.isNotBlank((CharSequence)param.getDayanProjectName())) {
                        DayanProjectJson dayanProjectJson = new DayanProjectJson(Long.valueOf(param.getDayanProjectId()), param.getDayanProjectName());
                        projectExtEntity.setDayanProject(dayanProjectJson);
                    }
                    projectExtEntity.setProjectId(projectEntity.getId());
                    projectExtraSave = this.projectExtService.save((Object)projectExtEntity);
                }
                return projectSave && projectExtraSave;
            }
            catch (Exception e) {
                t.setRollbackOnly();
                log.warn("Exception [{}]:", (Object)e.getMessage(), (Object)e);
                return false;
            }
        });
        if (Boolean.TRUE.equals(execute)) {
            return projectEntity.getId();
        }
        return null;
    }

    @Override
    public Boolean updateProject(ProjectUpdateParam param) throws BizException {
        ProjectStateEnum stateEnum;
        ArrayList updateStockDtos = new ArrayList();
        ProjectEntity projectEntity = (ProjectEntity)this.projectService.getById((Serializable)param.getId());
        Conditions.expectNotNull((Object)projectEntity, (BizError)PlatformConsoleErrorEnum.NULL_PROJECT);
        Conditions.expectTrue((param.getGmtModified().getTime() == projectEntity.getGmtModified().getTime() ? 1 : 0) != 0, (BizError)PlatformConsoleErrorEnum.NOT_NEWEST_PROJECT);
        if (Objects.equals(param.getButtonType(), ProjectUpdateButtonTypeEnum.SAVE_PUBLISH.getCode())) {
            Conditions.expectNotNull((Object)projectEntity.getAppId(), (BizError)PlatformConsoleErrorEnum.NOT_DIRECTED_APP);
        }
        PrototypeEntity prototypeEntity = (PrototypeEntity)this.prototypeService.getById((Serializable)projectEntity.getPrototypeId());
        Conditions.expectNotNull((Object)prototypeEntity, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_FOUND);
        this.validatedParam(prototypeEntity, projectEntity, param);
        ProjectEntity projectEntityNew = (ProjectEntity)BeanUtil.copyProperties((Object)projectEntity, ProjectEntity.class, (String[])new String[0]);
        BeanUtil.copyProperties((Object)param, (Object)projectEntityNew, (String[])new String[0]);
        if (!SpringEnvironmentUtils.isProdEnv() && param.getProd() != null) {
            projectEntityNew.setProd(param.getProd());
        }
        if ((stateEnum = this.getProjectState(projectEntity, param.getButtonType())) != null) {
            projectEntityNew.setState(stateEnum.getCode());
        }
        Long projectId = param.getId();
        ArrayList errorMsg = new ArrayList();
        Boolean result = (Boolean)this.transactionTemplate.execute(t -> {
            try {
                this.handleOption(projectEntityNew.getAppId(), projectId, param.getPlayAttributes(), updateStockDtos);
                BizProject bizProject = new BizProject(projectEntityNew);
                BizProjectConfigMap bizProjectConfigMap = bizProject.getBizProjectConfigMap();
                bizProjectConfigMap.findConfigErrors(new CheckMode(false, false));
                LambdaUpdateWrapper projectUpdateWrapper = new LambdaUpdateWrapper();
                projectUpdateWrapper.eq(ProjectEntity::getId, (Object)projectId);
                Integer source = projectEntity.getSource();
                projectEntityNew.setOperator(Objects.equals(ProjectCreateSourceEnum.ACTIVITY_PLATFORM.getCode(), source) ? this.ssoExtManager.getAdminInfo().getName() : "system");
                projectEntityNew.setGmtModified(new Date());
                boolean updateProject = this.projectService.update((Object)projectEntityNew, (Wrapper)projectUpdateWrapper);
                boolean isPlatform = Objects.equals(projectEntity.getSource(), ProjectCreateSourceEnum.ACTIVITY_PLATFORM.getCode());
                ProjectExtParam projectExt = param.getProjectExtra();
                boolean updateProjectExtra = true;
                if (isPlatform && projectExt != null) {
                    ProjectExtEntity extEntity = (ProjectExtEntity)BeanUtil.copyProperties((Object)projectExt, ProjectExtEntity.class, (String[])new String[0]);
                    LambdaUpdateWrapper projectExtEntityWrapper = new LambdaUpdateWrapper();
                    projectExtEntityWrapper.eq(ProjectExtEntity::getProjectId, (Object)projectId);
                    extEntity.setEffectTags(JSONObject.toJSONString(projectExt.getEffectTags()));
                    updateProjectExtra = this.projectExtService.saveOrUpdate((Object)extEntity, (Wrapper)projectExtEntityWrapper);
                }
                return updateProject && updateProjectExtra;
            }
            catch (Exception e) {
                t.setRollbackOnly();
                log.warn("\u4fdd\u5b58\u6d3b\u52a8\u5931\u8d25", (Throwable)e);
                if (e instanceof BizException && Objects.equals(((BizException)((Object)((Object)e))).getCode(), "2003004019")) {
                    log.warn("\u4fdd\u5b58\u6d3b\u52a8\u5931\u8d25:\u4e09\u65b9\u5e93\u5b58\u4e0d\u8db3", (Throwable)e);
                } else if (e instanceof BizRuntimeException && Objects.equals(((BizRuntimeException)e).getCode(), PlatformCoreErrorEnum.PRIZE_STOCK_NOT_ENOUGH.getCode())) {
                    log.warn("\u4fdd\u5b58\u6d3b\u52a8\u5931\u8d25:\u4e09\u65b9\u5e93\u5b58\u4e0d\u8db3", (Throwable)e);
                } else if (CollectionUtils.isNotEmpty((Collection)updateStockDtos)) {
                    updateStockDtos.forEach(u -> u.setType(Objects.equals(1, u.getType()) ? 0 : 1));
                    StockAdapter stockAdapter = (StockAdapter)this.galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "StockAdapter");
                    try {
                        stockAdapter.batchDeductStock(projectEntity.getAppId().toString(), updateStockDtos);
                    }
                    catch (BizException ex) {
                        log.warn("\u4fdd\u5b58\u6d3b\u52a8\u5931\u8d25:\u4e09\u65b9\u5e93\u5b58\u4e0d\u8db3", (Throwable)e);
                    }
                }
                errorMsg.add(e.getMessage());
                return false;
            }
        });
        if (CollectionUtils.isNotEmpty(errorMsg)) {
            throw new BizRuntimeException(PlatformConsoleErrorEnum.UPDATE_PROJECT_ERROR.setDesc((String)errorMsg.get(0)));
        }
        return result;
    }

    private void handleOption(Long appId, Long projectId, PlayAttributesJsonParam playAttributesJsonParam, List<UpdateStockDto> updateStockDtos) throws BizException {
        if (CollectionUtils.isEmpty(playAttributesJsonParam.getRules())) {
            this.optionManager.batchOperationalOption(appId, projectId, new ArrayList<OperationalOptionParam>(), updateStockDtos);
        } else {
            List<OperationalOptionParam> optionParams = this.buildOperationalOptionParams(playAttributesJsonParam.getRules(), projectId);
            if (optionParams.stream().anyMatch(u -> u.getOptionType().equals(OptionTypeEnum.PROCUREMENT.getCode()))) {
                Conditions.expectNotNull((Object)appId, (BizError)PlatformConsoleErrorEnum.NOT_DIRECTED_APP);
            }
            this.optionManager.batchOperationalOption(appId, projectId, optionParams, updateStockDtos);
        }
    }

    private List<OperationalOptionParam> buildOperationalOptionParams(List<StrategyJsonParam> strategyJsonParams, Long projectId) {
        ArrayList<OperationalOptionParam> optionParams = new ArrayList<OperationalOptionParam>();
        if (CollectionUtils.isNotEmpty(strategyJsonParams)) {
            for (StrategyJsonParam rus : strategyJsonParams) {
                List<LayeredRuleJsonParm> layeredRules;
                String ruId = rus.getId();
                List<OptionJsonParam> options = rus.getOptions();
                for (OptionJsonParam option : options) {
                    OperationalOptionParam operationalOptionParam = this.transformOption(option, projectId, ruId, rus.getName());
                    optionParams.add(operationalOptionParam);
                }
                if (!rus.isLayeredEnable() || !CollectionUtils.isNotEmpty(layeredRules = rus.getLayeredRules())) continue;
                for (LayeredRuleJsonParm layeredRule : layeredRules) {
                    List<OptionJsonParam> optionsLayered = layeredRule.getOptions();
                    for (OptionJsonParam optionJsonParam : optionsLayered) {
                        OperationalOptionParam operationalOptionParam = this.transformOption(optionJsonParam, projectId, layeredRule.getId(), layeredRule.getName());
                        optionParams.add(operationalOptionParam);
                    }
                }
            }
        }
        return optionParams;
    }

    private OperationalOptionParam transformOption(OptionJsonParam param, Long projectId, String ruId, String ruName) {
        OperationalOptionParam operationalOptionParam = new OperationalOptionParam();
        operationalOptionParam.setProjectId(projectId);
        operationalOptionParam.setId(param.getId());
        operationalOptionParam.setRuleId(ruId);
        operationalOptionParam.setRuleName(ruName);
        operationalOptionParam.setOptionName(param.getName());
        operationalOptionParam.setOptionType(param.getType());
        operationalOptionParam.setOptionImg1(param.getIcon());
        operationalOptionParam.setOptionImg2(param.getIcon2());
        operationalOptionParam.setPrizeId(param.getPrizeId());
        if (!Objects.equals(param.getType(), OptionTypeEnum.THANKS.getCode())) {
            operationalOptionParam.setRate(new BigDecimal(param.getRate()));
            if (param.getTotalStock() != null) {
                operationalOptionParam.setTotalStock(Math.toIntExact(param.getTotalStock()));
            } else if (Objects.equals(param.getType(), OptionTypeEnum.SP.getCode())) {
                operationalOptionParam.setTotalStock(null);
            }
        }
        operationalOptionParam.setUserLimit(param.getUserLimit());
        operationalOptionParam.setUserLimitType(param.getUserLimitType());
        operationalOptionParam.setAwardLimit(param.getAwardLimit());
        operationalOptionParam.setAwardLimitType(param.getAwardLimitType());
        operationalOptionParam.setSendCount(param.getSendCount());
        operationalOptionParam.setShowIndexType(param.getShowIndexType());
        operationalOptionParam.setAtleastTimes(param.getAtleastTimes());
        operationalOptionParam.setMultipleOption(param.isMultipleOption() ? 1 : 0);
        operationalOptionParam.setItemId(param.getItemId());
        operationalOptionParam.setBizType(param.getBizType());
        return operationalOptionParam;
    }

    private ProjectStateEnum getProjectState(ProjectEntity projectEntity, Integer buttonType) {
        ProjectStateEnum stateEnum = null;
        if (Objects.equals(projectEntity.getState(), ProjectStateEnum.ON_LINE.getCode())) {
            Conditions.expectTrue((boolean)Objects.equals(buttonType, ProjectUpdateButtonTypeEnum.SAVE_PUBLISH.getCode()), (BizError)PlatformConsoleErrorEnum.NOT_ALLOW_SAVE);
        } else if (Objects.equals(0, projectEntity.getSource())) {
            stateEnum = ProjectStateEnum.WAIT_PUBLISH;
            if (Objects.equals(buttonType, ProjectUpdateButtonTypeEnum.SAVE_PUBLISH.getCode())) {
                stateEnum = ProjectStateEnum.WAIT_ON_LINE;
            }
        } else {
            stateEnum = Objects.equals(buttonType, ProjectUpdateButtonTypeEnum.SAVE_PUBLISH.getCode()) ? ProjectStateEnum.ON_LINE : ProjectStateEnum.WAIT_ON_LINE;
        }
        return stateEnum;
    }

    private void validatedParam(PrototypeEntity prototypeEntity, ProjectEntity oldEntity, ProjectUpdateParam param) throws BizException {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Default.class);
        classes.add(GroupByResponsibility.Operator.class);
        if (Objects.equals(prototypeEntity.getPrototypeType(), PrototypeTypeEnum.CUSTOMIZATION.getCode())) {
            classes.add(GroupByPrototypeType.Custom.class);
        }
        if (Objects.equals(oldEntity.getSource(), ProjectCreateSourceEnum.CREDITS_STORE.getCode())) {
            classes.add(GroupByProjectCreateSource.CreditsStore.class);
        }
        Class[] classesNew = new Class[classes.size()];
        ValidateUtils.validate((Object)param, (Class[])classes.toArray(classesNew));
    }

    @Override
    public ProjectQueryVo getProjectByProjectId(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProjectEntity::getId, (Object)projectId);
        ProjectEntity projectEntity = (ProjectEntity)this.projectService.getOne((Wrapper)wrapper);
        if (projectEntity == null) {
            return null;
        }
        PrototypeEntity prototypeEntity = (PrototypeEntity)this.prototypeService.getById((Serializable)projectEntity.getPrototypeId());
        ObjectBuildFactory.mergeConfig((PrototypeEntity)prototypeEntity, (ProjectEntity)projectEntity);
        ProjectQueryVo projectQueryVo = (ProjectQueryVo)BeanUtil.copyProperties((Object)projectEntity, ProjectQueryVo.class, (String[])new String[0]);
        if (Objects.equals(projectEntity.getSource(), ProjectCreateSourceEnum.ACTIVITY_PLATFORM.getCode())) {
            LambdaQueryWrapper projectExtWrapper = new LambdaQueryWrapper();
            projectExtWrapper.eq(ProjectExtEntity::getProjectId, (Object)projectId);
            ProjectExtEntity extEntity = (ProjectExtEntity)this.projectExtService.getOne((Wrapper)projectExtWrapper);
            ProjectExtraBaseVo projectExtraBaseVo = (ProjectExtraBaseVo)BeanUtil.copyProperties((Object)extEntity, ProjectExtraBaseVo.class, (String[])new String[0]);
            projectExtraBaseVo.setEffectTags(JSONObject.parseArray((String)extEntity.getEffectTags(), String.class));
            projectQueryVo.setProjectExtra(projectExtraBaseVo);
        }
        List<SpEntity> spEntities = this.spManager.listAllSps(prototypeEntity.getId());
        List spVos = BeanUtil.copyToList(spEntities, SpVo.class);
        projectQueryVo.setSps(spVos);
        return projectQueryVo;
    }

    @Override
    public Boolean updateState(Long projectId, Integer state) {
        ProjectEntity projectEntity = (ProjectEntity)this.projectService.getById((Serializable)projectId);
        Conditions.expectNotNull((Object)projectEntity, (BizError)PlatformConsoleErrorEnum.NULL_PROJECT);
        Integer stateOld = projectEntity.getState();
        long now = System.currentTimeMillis();
        Integer stateNew = null;
        if (Objects.equals(state, ProjectStateEnum.OFF_LINE.getCode())) {
            stateNew = state;
        } else if (Objects.equals(stateOld, ProjectStateEnum.OFF_LINE.getCode()) && Objects.equals(state, ProjectStateEnum.ON_LINE.getCode())) {
            Conditions.expectNotNull((Object)projectEntity.getAppId(), (BizError)PlatformConsoleErrorEnum.NOT_DIRECTED_APP);
            Conditions.expectTrue((projectEntity.getEndTime().getTime() > now ? 1 : 0) != 0, (BizError)PlatformConsoleErrorEnum.END_TIME_ERROR);
            stateNew = state;
        } else if (Objects.equals(stateOld, ProjectStateEnum.WAIT_ON_LINE.getCode()) && Objects.equals(state, ProjectStateEnum.ON_LINE.getCode())) {
            stateNew = state;
        }
        Conditions.expectNotNull((Object)stateNew, (BizError)PlatformConsoleErrorEnum.STATE_CHANGE_ERROR);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(ProjectEntity::getId, (Object)projectId)).set(ProjectEntity::getState, (Object)stateNew);
        return this.projectService.update((Wrapper)updateWrapper);
    }

    @Override
    public boolean copyProject(ProjectCopyParam param) {
        ProjectEntity projectEntity = (ProjectEntity)this.projectService.getById((Serializable)param.getProjectId());
        ProjectEntity projectEntityCopy = (ProjectEntity)BeanUtil.copyProperties((Object)projectEntity, ProjectEntity.class, (String[])new String[0]);
        projectEntityCopy.setId(null);
        projectEntityCopy.setProjectName(projectEntity.getProjectName() + "_copy");
        List rules = projectEntity.getPlayAttributes().getRules();
        List<StrategyJson> resetRules = this.resetRules(rules);
        projectEntity.getPlayAttributes().setRules(resetRules);
        projectEntityCopy.setPlayAttributes(projectEntity.getPlayAttributes());
        projectEntityCopy.setState(ProjectStateEnum.INIT.getCode());
        projectEntityCopy.setGmtCreate(new Date());
        projectEntityCopy.setGmtModified(new Date());
        projectEntityCopy.setOperator(this.ssoExtManager.getAdminInfo().getName());
        projectEntityCopy.setProd(param.getProd());
        projectEntityCopy.setStartTime(null);
        projectEntityCopy.setEndTime(null);
        projectEntityCopy.setOpenbs(Integer.valueOf(0));
        return Boolean.TRUE.equals(this.transactionTemplate.execute(t -> {
            boolean saveProject = false;
            boolean saveProjectExtState = true;
            try {
                Long num = this.projectService.saveProject(projectEntityCopy);
                saveProject = num > 0L;
                boolean isPlatform = Objects.equals(projectEntity.getSource(), ProjectCreateSourceEnum.ACTIVITY_PLATFORM.getCode());
                if (saveProject && isPlatform) {
                    LambdaQueryWrapper entityLambdaQueryWrapper = new LambdaQueryWrapper();
                    entityLambdaQueryWrapper.eq(ProjectExtEntity::getProjectId, (Object)param.getProjectId());
                    ProjectExtEntity extEntity = (ProjectExtEntity)this.projectExtService.getOne((Wrapper)entityLambdaQueryWrapper);
                    ProjectExtEntity projectExtEntityCopy = (ProjectExtEntity)BeanUtil.copyProperties((Object)extEntity, ProjectExtEntity.class, (String[])new String[0]);
                    projectExtEntityCopy.setId(null);
                    projectExtEntityCopy.setProjectId(projectEntityCopy.getId());
                    projectExtEntityCopy.setGmtCreate(new Date());
                    projectExtEntityCopy.setGmtModified(new Date());
                    saveProjectExtState = this.projectExtService.save((Object)projectExtEntityCopy);
                }
            }
            catch (Exception e) {
                log.warn("Exception [{}]:", (Object)e.getMessage(), (Object)e);
                t.setRollbackOnly();
            }
            return saveProject && saveProjectExtState;
        }));
    }

    @Override
    public ProjectQueryVo getReadyCopyProject(Long projectId) {
        ProjectQueryVo projectQuerySourceVo = this.getProjectByProjectId(projectId);
        ProjectQueryVo projectQueryTargetVo = (ProjectQueryVo)BeanUtil.copyProperties((Object)projectQuerySourceVo, ProjectQueryVo.class, (String[])new String[0]);
        projectQueryTargetVo.setId(null);
        projectQueryTargetVo.setProjectName(String.format("%s_copy", projectQuerySourceVo.getProjectName()));
        projectQueryTargetVo.setState(ProjectStateEnum.INIT.getCode());
        projectQueryTargetVo.setStartTime(null);
        projectQueryTargetVo.setEndTime(null);
        PlayAttributesJsonVo playAttributes = projectQueryTargetVo.getPlayAttributes();
        if (playAttributes == null || CollectionUtils.isEmpty(playAttributes.getRules())) {
            return projectQueryTargetVo;
        }
        List<StrategyJsonVo> strategyJsonVos = playAttributes.getRules();
        List strategyJsons = BeanUtil.copyToList(strategyJsonVos, StrategyJson.class);
        List<StrategyJson> resetRules = this.resetRules(strategyJsons);
        projectQueryTargetVo.getPlayAttributes().setRules(BeanUtil.copyToList(resetRules, StrategyJsonVo.class));
        return projectQueryTargetVo;
    }

    private List<StrategyJson> resetRules(List<StrategyJson> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            return new ArrayList<StrategyJson>();
        }
        for (StrategyJson rule : rules) {
            List layeredRules;
            List options = rule.getOptions();
            if (CollectionUtils.isNotEmpty((Collection)options)) {
                for (OptionJson option : options) {
                    option.setId(null);
                    option.setTotalStock(Long.valueOf(0L));
                    option.setUsedStock(Long.valueOf(0L));
                }
            }
            if (CollectionUtils.isEmpty((Collection)(layeredRules = rule.getLayeredRules()))) continue;
            for (LayeredRuleJson layeredRule : layeredRules) {
                List optionsLayered = layeredRule.getOptions();
                if (CollectionUtils.isNotEmpty((Collection)optionsLayered)) continue;
                for (OptionJson optionLayered : optionsLayered) {
                    optionLayered.setId(null);
                    optionLayered.setTotalStock(Long.valueOf(0L));
                    optionLayered.setUsedStock(Long.valueOf(0L));
                }
            }
        }
        return rules;
    }
}

