/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.galaxy.api.model.dto.PrototypeDto;
import cn.com.duiba.galaxy.api.model.dto.SpDto;
import cn.com.duiba.galaxy.basic.enums.DeleteFieldTypeEnum;
import cn.com.duiba.galaxy.basic.enums.PrototypeTypeEnum;
import cn.com.duiba.galaxy.basic.model.entity.ProjectEntity;
import cn.com.duiba.galaxy.basic.model.entity.PrototypeEntity;
import cn.com.duiba.galaxy.basic.model.entity.PrototypeJarEntity;
import cn.com.duiba.galaxy.basic.model.entity.SpEntity;
import cn.com.duiba.galaxy.basic.model.jsonfield.PlayAttributesJson;
import cn.com.duiba.galaxy.basic.model.jsonfield.SkinJson;
import cn.com.duiba.galaxy.basic.service.ProjectService;
import cn.com.duiba.galaxy.basic.service.PrototypeJarService;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.basic.service.SpService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.enums.PrototypeStateEnum;
import cn.com.duiba.galaxy.console.manager.PrototypeManager;
import cn.com.duiba.galaxy.console.manager.SpManager;
import cn.com.duiba.galaxy.console.manager.SsoExtManager;
import cn.com.duiba.galaxy.console.model.param.SpParam;
import cn.com.duiba.galaxy.console.model.param.prototype.CrossPushPrototypeParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeQueryParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeSaveParam;
import cn.com.duiba.galaxy.console.model.param.prototype.PrototypeUpdateParam;
import cn.com.duiba.galaxy.console.model.param.prototype.SimplePrototypeParam;
import cn.com.duiba.galaxy.console.model.vo.PagePrototypeVo;
import cn.com.duiba.galaxy.console.model.vo.SpVo;
import cn.com.duiba.galaxy.console.model.vo.project.ProjectSimpleVo;
import cn.com.duiba.galaxy.console.model.vo.prototype.PrototypeListVo;
import cn.com.duiba.galaxy.console.model.vo.prototype.PrototypeVo;
import cn.com.duiba.galaxy.core.activity.BizPrototypeConfigMapImpl;
import cn.com.duiba.galaxy.core.activity.CheckMode;
import cn.com.duiba.galaxy.core.activity.skin.SkinTypeEnum;
import cn.com.duiba.galaxy.core.util.http.HttpClient;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractPrototypeManagerImpl
implements PrototypeManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractPrototypeManagerImpl.class);
    @Autowired
    protected PrototypeService prototypeService;
    @Autowired
    protected ProjectService projectService;
    @Autowired
    protected SpService spService;
    @Autowired
    protected SpManager spManager;
    @Autowired
    protected SsoExtManager ssoExtManager;
    @Resource
    private PrototypeJarService prototypeJarService;
    @Resource
    private TransactionTemplate transactionTemplate;
    private static final String PUSH_PROTOTYPE_KEY1 = "prototypeDto";
    private static final String PUSH_PROTOTYPE_KEY2 = "spDtos";

    @Override
    public boolean newPrototype(PrototypeSaveParam param) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PrototypeEntity::getPrototypeName, (Object)param.getPrototypeName());
        PrototypeEntity prototypeEntityOld = (PrototypeEntity)this.prototypeService.getOne((Wrapper)wrapper);
        Conditions.expectTrue((prototypeEntityOld == null ? 1 : 0) != 0, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NAME_REPEAT);
        PrototypeEntity prototypeEntityNew = (PrototypeEntity)BeanUtil.copyProperties((Object)param, PrototypeEntity.class, (String[])new String[0]);
        prototypeEntityNew.setOperator(this.ssoExtManager.getAdminInfo().getName());
        return this.prototypeService.save((Object)prototypeEntityNew);
    }

    @Override
    public PrototypeVo getPrototype(SimplePrototypeParam param) {
        PrototypeEntity entity = this.prototypeService.getPrototype(param.getId(), param.getPrototypeName());
        if (entity == null) {
            return null;
        }
        LambdaQueryWrapper spEntityLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)spEntityLambdaQueryWrapper.eq(SpEntity::getPrototypeId, (Object)param.getId())).eq(SpEntity::getDeleted, (Object)DeleteFieldTypeEnum.UN_DELETE.getCode());
        List spEntities = this.spService.list((Wrapper)spEntityLambdaQueryWrapper);
        PrototypeVo prototypeVo = (PrototypeVo)BeanUtil.copyProperties((Object)entity, PrototypeVo.class, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)spEntities)) {
            prototypeVo.setSps(BeanUtil.copyToList((Collection)spEntities, SpVo.class));
        }
        return prototypeVo;
    }

    @Override
    public PagePrototypeVo listPrototypes(PrototypeQueryParam param) {
        Page entityPage = this.prototypeService.conditionAndPageQuery(param.getPrototypeCondition(), param.getProjectCondition(), (long)param.getPageNum().intValue(), (long)param.getPageSize().intValue(), param.getPrototypeType(), param.getState());
        Map<Object, Object> projectGroup = new HashMap();
        boolean isCustomization = PrototypeTypeEnum.CUSTOMIZATION.getCode().equals(param.getPrototypeType());
        if (isCustomization) {
            List prototypeIds = entityPage.getRecords().stream().map(PrototypeEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(CollectionUtils.isNotEmpty(prototypeIds), ProjectEntity::getPrototypeId, prototypeIds);
            List projectEntityList = this.projectService.list((Wrapper)wrapper);
            projectGroup = projectEntityList.stream().collect(Collectors.groupingBy(ProjectEntity::getPrototypeId, Collectors.toList()));
        }
        List prototypeEntities = entityPage.getRecords();
        List prototypeBaseVos = BeanUtil.copyToList((Collection)prototypeEntities, PrototypeListVo.class);
        if (Objects.equals(param.getPrototypeType(), PrototypeTypeEnum.CUSTOMIZATION.getCode())) {
            for (PrototypeListVo u : prototypeBaseVos) {
                List projectSimpleVos = null;
                List projectEntities = (List)projectGroup.get(u.getId());
                if (CollectionUtils.isNotEmpty((Collection)projectEntities)) {
                    List projectSimpleVos1 = BeanUtil.copyToList((Collection)projectEntities, ProjectSimpleVo.class);
                    projectSimpleVos = projectSimpleVos1.stream().sorted(Comparator.comparing(ProjectSimpleVo::getId).reversed()).collect(Collectors.toList());
                }
                u.setProjectSimpleVos(projectSimpleVos);
            }
        }
        return PagePrototypeVo.newBuilder().list(prototypeBaseVos).totalCount(entityPage.getTotal()).build();
    }

    @Override
    public Boolean updatePrototype(PrototypeUpdateParam param, Future<PrototypeJarEntity> task) throws Exception {
        PrototypeEntity prototypeEntity = (PrototypeEntity)this.prototypeService.getById((Serializable)param.getId());
        Conditions.expectNotNull((Object)prototypeEntity, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_FOUND);
        if (!Objects.equals(param.getPrototypeName(), prototypeEntity.getPrototypeName())) {
            PrototypeEntity prototypeQuery = this.prototypeService.getPrototype(null, param.getPrototypeName());
            Conditions.expectTrue((prototypeQuery == null ? 1 : 0) != 0, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NAME_REPEAT);
        }
        PrototypeStateEnum prototypeStateEnum = this.getPrototypeState(prototypeEntity);
        PrototypeEntity prototypeEntityNew = (PrototypeEntity)BeanUtil.copyProperties((Object)prototypeEntity, PrototypeEntity.class, (String[])new String[]{"gmtCreate", "gmtModified"});
        BeanUtil.copyProperties((Object)param, (Object)prototypeEntityNew, (String[])new String[0]);
        prototypeEntityNew.setGmtModified(new Date());
        if (prototypeStateEnum != null) {
            prototypeEntityNew.setState(prototypeStateEnum.getCode());
        }
        boolean update = (Boolean)this.transactionTemplate.execute(t -> {
            try {
                this.saveSps(param.getSps(), prototypeEntity.getId());
                BizPrototypeConfigMapImpl bizPrototypeConfigMap = new BizPrototypeConfigMapImpl(prototypeEntityNew);
                bizPrototypeConfigMap.findConfigErrors(new CheckMode(true, Objects.equals(prototypeEntity.getPrototypeType(), PrototypeTypeEnum.CUSTOMIZATION.getCode())));
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(PrototypeEntity::getId, (Object)param.getId());
                prototypeEntityNew.setOperator(this.ssoExtManager.getAdminInfo().getName());
                String commitId = this.savePrototypeJarEntity(task == null ? null : (PrototypeJarEntity)task.get());
                if (StringUtils.isNotBlank((CharSequence)commitId)) {
                    prototypeEntityNew.setCommitId(commitId);
                }
                return this.prototypeService.update((Object)prototypeEntityNew, (Wrapper)updateWrapper);
            }
            catch (Exception e) {
                log.warn("Exception [{}]:", (Object)e.getMessage(), (Object)e);
                t.setRollbackOnly();
                return false;
            }
        });
        return update;
    }

    private String savePrototypeJarEntity(PrototypeJarEntity prototypeJarEntity) {
        if (prototypeJarEntity != null && prototypeJarEntity.getPrototypeJar() != null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            Long protoytypeId = prototypeJarEntity.getPrototypeId();
            String commitId = prototypeJarEntity.getCommitId();
            wrapper.eq(PrototypeJarEntity::getPrototypeId, (Object)protoytypeId);
            PrototypeJarEntity jarEntity = new PrototypeJarEntity();
            jarEntity.setPrototypeId(protoytypeId);
            jarEntity.setSourceId("1");
            jarEntity.setCommitId(commitId);
            jarEntity.setPrototypeJar(prototypeJarEntity.getPrototypeJar());
            this.prototypeJarService.saveOrUpdate((Object)jarEntity, (Wrapper)wrapper);
            return prototypeJarEntity.getCommitId();
        }
        return null;
    }

    private void saveSps(List<SpParam> params, Long prototypeId) {
        List<SpEntity> entitiesOld;
        List<Object> delEntities = entitiesOld = this.spManager.listAllSps(prototypeId);
        if (CollectionUtils.isNotEmpty(params)) {
            List entities = BeanUtil.copyToList(params, SpEntity.class);
            entities.forEach(u -> u.setPrototypeId(prototypeId));
            this.spService.saveOrUpdateBatch((Collection)entities);
            List idsNew = params.stream().map(SpParam::getId).collect(Collectors.toList());
            delEntities = entitiesOld.stream().filter(u -> !idsNew.contains(u.getId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(delEntities)) {
            delEntities.forEach(u -> u.setDeleted(DeleteFieldTypeEnum.DELETE.getCode()));
        }
        this.spService.updateBatchById(delEntities);
    }

    private PrototypeStateEnum getPrototypeState(PrototypeEntity prototypeEntity) {
        PrototypeStateEnum prototypeStateEnum = null;
        if (Objects.equals(prototypeEntity.getPrototypeType(), PrototypeTypeEnum.TEMPLATE.getCode())) {
            if (prototypeEntity.getGmtCreate().getTime() == prototypeEntity.getGmtModified().getTime()) {
                prototypeStateEnum = PrototypeStateEnum.NOT_ENABLED;
            } else if (prototypeEntity.getViewAttributes() != null && prototypeEntity.getViewAttributes().getViewConfig() != null) {
                prototypeStateEnum = PrototypeStateEnum.ENABLED;
            }
        } else {
            prototypeStateEnum = PrototypeStateEnum.ENABLED;
        }
        return prototypeStateEnum;
    }

    @Override
    public String getSkinOfIndex(Long prototypeId) {
        PrototypeEntity prototype = (PrototypeEntity)this.prototypeService.getById((Serializable)prototypeId);
        Conditions.expectNotNull((Object)prototype, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_FOUND);
        return Optional.of(prototype).map(PrototypeEntity::getPlayAttributes).map(PlayAttributesJson::getSkins).flatMap(v -> v.stream().filter(s -> Objects.equals(SkinTypeEnum.INDEX.getType(), s.getType())).findFirst()).map(SkinJson::getHtml).orElseThrow(() -> new BizRuntimeException((BizError)PlatformConsoleErrorEnum.SKIN_NOT_FOUND));
    }

    @Override
    public Boolean copyPrototype(Long prototypeId) {
        return null;
    }

    @Override
    public Boolean pushPrototype(CrossPushPrototypeParam param) {
        PrototypeEntity prototypeEntity = (PrototypeEntity)this.prototypeService.getById((Serializable)param.getPrototypeId());
        if (prototypeEntity == null) {
            throw new BizRuntimeException((BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_FOUND);
        }
        PrototypeDto prototypeDto = (PrototypeDto)BeanUtil.copyProperties((Object)prototypeEntity, PrototypeDto.class, (String[])new String[0]);
        prototypeDto.setOperator("system");
        prototypeDto.setState(PrototypeStateEnum.TO_EDIT.getCode());
        prototypeDto.setPrototypeName(String.format(prototypeDto.getPrototypeName() + "_%s", RandomUtil.randomString((int)6)));
        HashMap<String, String> dtoMap = new HashMap<String, String>();
        dtoMap.put(PUSH_PROTOTYPE_KEY1, JSONObject.toJSONString((Object)prototypeDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        List spEntities = this.spService.listPrototypeSp(param.getPrototypeId());
        if (CollectionUtils.isNotEmpty((Collection)spEntities)) {
            List spDtos = BeanUtil.copyToList((Collection)spEntities, SpDto.class);
            spDtos.forEach(u -> u.setId(null));
            dtoMap.put(PUSH_PROTOTYPE_KEY2, JSONObject.toJSONString((Object)spDtos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        }
        log.info("\u539f\u578b:[{}]\u63a8\u9001request:{},url:{}", new Object[]{prototypeEntity.getId(), JSONObject.toJSONString(dtoMap), param.getUrl()});
        try {
            StringEntity requestBody = new StringEntity(JSON.toJSONString(dtoMap), ContentType.APPLICATION_JSON);
            String result = HttpClient.doPost((String)param.getUrl(), (HttpEntity)requestBody);
            log.info("\u539f\u578b:{}\uff0c\u63a8\u9001\u7ed3\u679c:{}", (Object)prototypeEntity.getId(), (Object)result);
        }
        catch (Exception e) {
            log.info("\u539f\u578b\u63a8\u9001\u5931\u8d25,prototypeId:{}", (Object)e, Optional.ofNullable(prototypeEntity.getId()).orElse(null));
            return false;
        }
        return true;
    }

    @Override
    public Boolean receiveAndSavePrototype(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        if (map.get(PUSH_PROTOTYPE_KEY1) == null) {
            return false;
        }
        PrototypeDto prototypeDto = (PrototypeDto)JSONObject.parseObject((String)map.get(PUSH_PROTOTYPE_KEY1), PrototypeDto.class);
        PrototypeEntity prototypeEntity = (PrototypeEntity)BeanUtil.copyProperties((Object)prototypeDto, PrototypeEntity.class, (String[])new String[0]);
        prototypeEntity.setId(null);
        prototypeEntity.setGmtModified(null);
        prototypeEntity.setGmtCreate(null);
        prototypeEntity.setState(PrototypeStateEnum.TO_EDIT.getCode());
        return (Boolean)this.transactionTemplate.execute(t -> {
            boolean saveSp = true;
            boolean savePrototype = false;
            try {
                savePrototype = this.prototypeService.save((Object)prototypeEntity);
                if (map.get(PUSH_PROTOTYPE_KEY2) != null) {
                    List spDtos = JSONObject.parseArray((String)((String)map.get(PUSH_PROTOTYPE_KEY2)), SpDto.class);
                    List spEntities = BeanUtil.copyToList((Collection)spDtos, SpEntity.class);
                    if (savePrototype && CollectionUtils.isNotEmpty((Collection)spEntities)) {
                        for (SpEntity u : spEntities) {
                            u.setId(null);
                            u.setPrototypeId(prototypeEntity.getId());
                        }
                        saveSp = this.spService.saveBatch((Collection)spEntities);
                    }
                }
            }
            catch (Exception e) {
                log.warn("Exception [{}]:", (Object)e.getMessage(), (Object)e);
                t.setRollbackOnly();
            }
            return saveSp && savePrototype;
        });
    }

    @Override
    public void updatePrototypeState(Long prototypeId, Integer state) {
        PrototypeEntity oldEntity = (PrototypeEntity)this.prototypeService.getById((Serializable)prototypeId);
        Conditions.expectNotNull((Object)oldEntity, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_FOUND);
        Conditions.expectTrue((ObjectUtils.notEqual((Object)state, (Object)oldEntity.getState()) && ObjectUtils.notEqual((Object)state, (Object)PrototypeStateEnum.TO_EDIT.getCode()) ? 1 : 0) != 0, (BizError)PlatformConsoleErrorEnum.INVALID_CHANGE);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(PrototypeEntity::getId, (Object)prototypeId)).set(PrototypeEntity::getState, (Object)state)).set(PrototypeEntity::getOperator, (Object)this.ssoExtManager.getAdminInfo().getName());
        Conditions.expectTrue((boolean)this.prototypeService.update((Wrapper)updateWrapper), (BizError)PlatformConsoleErrorEnum.STATE_CHANGE_ERROR);
    }
}

