/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.CommonBackendManager;
import cn.com.duiba.galaxy.console.model.vo.EnumFieldVo;
import cn.com.duiba.galaxy.console.model.vo.EnumVo;
import cn.com.duiba.galaxy.console.util.PackageUtils;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class CommonBackendManagerImpl
implements CommonBackendManager {
    private static final Logger log = LoggerFactory.getLogger(CommonBackendManagerImpl.class);

    @Override
    public List<EnumVo> getEnumByName(@RequestParam(required=false) String name) {
        String[] enumPaths = new String[]{"cn.com.duiba.galaxy.console.enums", "cn.com.duiba.galaxy.basic.enums"};
        ArrayList resultList = Lists.newArrayList();
        for (String enumPath : enumPaths) {
            Set<Object> scan = new HashSet();
            try {
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    scan.add(Class.forName(String.format("%s.%s", enumPath, name)));
                } else {
                    scan = PackageUtils.getClasses(enumPath);
                }
            }
            catch (ClassNotFoundException e) {
                throw new BizRuntimeException((BizError)PlatformConsoleErrorEnum.ENUM_NOT_FOUND, (Throwable)e);
            }
            catch (IOException e) {
                throw new BizRuntimeException((BizError)PlatformConsoleErrorEnum.GET_ENUM_ERROR, (Throwable)e);
            }
            for (Class clazz : scan) {
                if (BizError.class.isAssignableFrom(clazz)) continue;
                T[] objects = clazz.getEnumConstants();
                Method getCode = CommonBackendManagerImpl.getQualifiedMethod(clazz, "getCode");
                Method getDesc = CommonBackendManagerImpl.getQualifiedMethod(clazz, "getDesc");
                if (Objects.isNull(getCode) || Objects.isNull(getDesc)) continue;
                ArrayList valueList = Lists.newArrayList();
                try {
                    for (Object obj : objects) {
                        valueList.add(EnumFieldVo.builder().code((Integer)getCode.invoke(obj, new Object[0])).desc((String)getDesc.invoke(obj, new Object[0])).build());
                    }
                    resultList.add(EnumVo.builder().enumName(clazz.getSimpleName()).valueList(valueList).build());
                }
                catch (Exception e) {
                    log.info("\u6839\u636e\u679a\u4e3e\u7c7b\u540d\u83b7\u53d6\u679a\u4e3e\u5e38\u91cf,\u679a\u4e3e\u7c7b[{}]\u65b9\u6cd5[{}]\u6267\u884c\u5931\u8d25,\u65b9\u6cd5\u5c06\u5ffd\u7565\u8be5\u679a\u4e3e\u7c7b,\u5982\u6709\u9700\u8981\u8bf7\u5148\u6309\u7167\u63a5\u53e3\u89c4\u8303\u8c03\u6574\u5c5e\u6027\u540d\uff01", new Object[]{clazz.getSimpleName(), name, e});
                }
            }
        }
        return resultList;
    }

    private static Method getQualifiedMethod(Class<?> classes, String name) {
        try {
            return classes.getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            log.info("\u6839\u636e\u679a\u4e3e\u7c7b\u540d\u83b7\u53d6\u679a\u4e3e\u5e38\u91cf,\u679a\u4e3e\u7c7b[{}]\u7f3a\u5931\u65b9\u6cd5[{}],\u65b9\u6cd5\u5c06\u5ffd\u7565\u8be5\u679a\u4e3e\u7c7b,\u5982\u6709\u9700\u8981\u8bf7\u5148\u6309\u7167\u63a5\u53e3\u89c4\u8303\u8c03\u6574\u5c5e\u6027\u540d\uff01", (Object)classes.getSimpleName(), (Object)name);
            return null;
        }
    }
}

