/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.adapter.base.adapter.PrizeAdapter;
import cn.com.duiba.galaxy.adapter.base.adapter.StockAdapter;
import cn.com.duiba.galaxy.adapter.base.dto.UpdateStockDto;
import cn.com.duiba.galaxy.adapter.base.enums.AdapterTypeEnum;
import cn.com.duiba.galaxy.adapter.base.enums.ItemBizTypeEnum;
import cn.com.duiba.galaxy.adapter.base.enums.PrizeTypeEnum;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapter;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapterFactory;
import cn.com.duiba.galaxy.adapter.base.params.ItemListParam;
import cn.com.duiba.galaxy.basic.enums.DeleteFieldTypeEnum;
import cn.com.duiba.galaxy.basic.enums.OptionTypeEnum;
import cn.com.duiba.galaxy.basic.model.entity.OptionEntity;
import cn.com.duiba.galaxy.basic.model.entity.PrizeEntity;
import cn.com.duiba.galaxy.basic.service.OptionService;
import cn.com.duiba.galaxy.basic.service.PrizeService;
import cn.com.duiba.galaxy.console.manager.OptionManager;
import cn.com.duiba.galaxy.console.model.param.OperationalOptionParam;
import cn.com.duiba.galaxy.core.enums.PlatformCoreErrorEnum;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OptionManagerImpl
implements OptionManager {
    @Autowired
    private OptionService optionService;
    @Autowired
    private PrizeService prizeService;
    @Autowired
    private GalaxyAdapterFactory<GalaxyAdapter> galaxyAdapterFactory;

    @Override
    public Boolean operationalOption(OperationalOptionParam param) {
        return null;
    }

    @Override
    public Boolean batchOperationalOption(Long appId, Long projectId, List<OperationalOptionParam> operationalOptionParamList, List<UpdateStockDto> updateStockDtos) throws BizException {
        StockAdapter stockAdapter = (StockAdapter)this.galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "StockAdapter");
        List<OperationalOptionParam> collect = operationalOptionParamList.stream().filter(a -> Objects.isNull(a.getId())).collect(Collectors.toList());
        List<OperationalOptionParam> updateOption = operationalOptionParamList.stream().filter(a -> Objects.nonNull(a.getId())).collect(Collectors.toList());
        Map<String, List<OperationalOptionParam>> itemIdToMap = operationalOptionParamList.stream().filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode())).collect(Collectors.groupingBy(o -> o.getItemId() + o.getBizType()));
        Map<String, Integer> creditItemStock = operationalOptionParamList.stream().filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()) && Objects.equals(o.getBizType(), ItemBizTypeEnum.CREDIT.getCode())).collect(Collectors.groupingBy(OperationalOptionParam::getItemId, Collectors.summingInt(OperationalOptionParam::getTotalStock)));
        Map<String, Integer> ownItemStock = operationalOptionParamList.stream().filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode()) && Objects.equals(o.getBizType(), ItemBizTypeEnum.OWN.getCode())).collect(Collectors.groupingBy(OperationalOptionParam::getItemId, Collectors.summingInt(OperationalOptionParam::getTotalStock)));
        List optionEntities2 = BeanUtils.copyList(updateOption, OptionEntity.class);
        Map<Long, Integer> prizeOption = new HashMap<Long, Integer>();
        List oldOption = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.optionService.lambdaQuery().eq(OptionEntity::getProjectId, (Object)projectId)).eq(OptionEntity::getDeleted, (Object)DeleteFieldTypeEnum.UN_DELETE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)optionEntities2)) {
            prizeOption = oldOption.stream().filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode())).collect(Collectors.groupingBy(OptionEntity::getPrizeId, Collectors.summingInt(OptionEntity::getTotalStock)));
        }
        HashMap<Long, Integer> finalPrizeOption = prizeOption;
        HashMap<String, Long> itemIdTypeToPrizeId = new HashMap<String, Long>();
        this.handlePrize(appId, updateStockDtos, creditItemStock, finalPrizeOption, itemIdTypeToPrizeId, ItemBizTypeEnum.CREDIT.getCode());
        this.handlePrize(appId, updateStockDtos, ownItemStock, finalPrizeOption, itemIdTypeToPrizeId, ItemBizTypeEnum.OWN.getCode());
        List<Object> optionEntities = new ArrayList<OptionEntity>();
        if (CollectionUtils.isNotEmpty(collect)) {
            collect.forEach(o -> {
                if (StringUtils.isNumeric((CharSequence)o.getItemId())) {
                    o.setPrizeId(itemIdTypeToPrizeId.getOrDefault(o.getItemId() + o.getBizType(), 0L));
                }
            });
            optionEntities = BeanUtils.copyList(collect, OptionEntity.class);
        }
        if (CollectionUtils.isNotEmpty(updateOption)) {
            this.handleUpdateOption(operationalOptionParamList, updateStockDtos, updateOption, oldOption, itemIdTypeToPrizeId, optionEntities);
        } else {
            this.handleAllDelOption(updateStockDtos, oldOption, optionEntities);
        }
        this.handleStock(appId, updateStockDtos, stockAdapter, itemIdToMap);
        if (CollectionUtils.isNotEmpty(optionEntities)) {
            this.optionService.saveOrUpdateBatch(optionEntities);
        }
        return true;
    }

    private void handlePrize(Long appId, List<UpdateStockDto> updateStockDtos, Map<String, Integer> itemStock, Map<Long, Integer> finalPrizeOption, Map<String, Long> itemIdTypeToPrizeId, Integer bizType) {
        Set<String> itemIds = itemStock.keySet();
        if (CollectionUtils.isEmpty(itemIds)) {
            return;
        }
        Set<Long> collect4 = itemIds.stream().map(c -> {
            if (StringUtils.isNumeric((CharSequence)c)) {
                return Long.valueOf(c);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        Collection prizeEntities = null;
        if (CollectionUtils.isNotEmpty(collect4)) {
            prizeEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.prizeService.lambdaQuery().eq(PrizeEntity::getThirdAppId, (Object)appId)).in(CollectionUtils.isNotEmpty(collect4), PrizeEntity::getRefId, collect4)).eq(PrizeEntity::getSource, (Object)bizType)).eq(PrizeEntity::getDeleted, (Object)DeleteFieldTypeEnum.UN_DELETE.getCode())).list();
        }
        if (CollectionUtils.isNotEmpty(prizeEntities)) {
            Map<String, Long> collect2 = prizeEntities.stream().collect(Collectors.toMap(p -> p.getRefId().toString() + p.getSource(), PrizeEntity::getId));
            itemIdTypeToPrizeId.putAll(collect2);
            List<Long> collect10 = prizeEntities.stream().map(PrizeEntity::getRefId).collect(Collectors.toList());
            prizeEntities.forEach(c -> {
                UpdateStockDto stockDto;
                Integer integer = (Integer)itemStock.get(c.getRefId().toString());
                if (Objects.isNull(integer) || integer < 0) {
                    return;
                }
                Integer oldStock = finalPrizeOption.getOrDefault(c.getId(), 0);
                Long l = (Objects.nonNull(c.getUsedStock()) ? c.getUsedStock() : 0L) - (long)oldStock.intValue() + (long)integer.intValue();
                if ((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0L) > l) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.prizeService.lambdaUpdate().set(PrizeEntity::getTotalStock, (Object)l)).set(PrizeEntity::getUsedStock, (Object)l)).eq(PrizeEntity::getThirdAppId, (Object)appId)).eq(PrizeEntity::getRefId, (Object)c.getRefId())).eq(PrizeEntity::getSource, (Object)bizType)).eq(PrizeEntity::getDeleted, (Object)DeleteFieldTypeEnum.UN_DELETE.getCode())).update();
                    stockDto = new UpdateStockDto();
                    stockDto.setType(1);
                    stockDto.setNum(Long.valueOf((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0L) - l));
                    if (Objects.equals(bizType, ItemBizTypeEnum.CREDIT.getCode())) {
                        stockDto.setItemId(c.getRefId());
                    } else if (Objects.equals(bizType, ItemBizTypeEnum.OWN.getCode())) {
                        stockDto.setAppItemId(c.getRefId());
                    }
                    updateStockDtos.add(stockDto);
                }
                if ((Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0L) < l) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.prizeService.lambdaUpdate().set(PrizeEntity::getUsedStock, (Object)l)).set(PrizeEntity::getTotalStock, (Object)l)).eq(PrizeEntity::getThirdAppId, (Object)appId)).eq(PrizeEntity::getRefId, (Object)c.getRefId())).eq(PrizeEntity::getSource, (Object)bizType)).eq(PrizeEntity::getDeleted, (Object)DeleteFieldTypeEnum.UN_DELETE.getCode())).update();
                    stockDto = new UpdateStockDto();
                    stockDto.setType(0);
                    stockDto.setNum(Long.valueOf(l - (Objects.nonNull(c.getTotalStock()) ? c.getTotalStock() : 0L)));
                    if (Objects.equals(bizType, ItemBizTypeEnum.CREDIT.getCode())) {
                        stockDto.setItemId(c.getRefId());
                    } else if (Objects.equals(bizType, ItemBizTypeEnum.OWN.getCode())) {
                        stockDto.setAppItemId(c.getRefId());
                    }
                    updateStockDtos.add(stockDto);
                }
            });
            collect10.forEach(collect4::remove);
        }
        collect4.forEach(f -> {
            Integer integer = (Integer)itemStock.get(f.toString());
            if (Objects.isNull(integer) || integer <= 0) {
                return;
            }
            UpdateStockDto stockDto = new UpdateStockDto();
            stockDto.setType(0);
            stockDto.setNum(Long.valueOf(integer.longValue()));
            if (Objects.equals(bizType, ItemBizTypeEnum.CREDIT.getCode())) {
                stockDto.setItemId(f);
            } else if (Objects.equals(bizType, ItemBizTypeEnum.OWN.getCode())) {
                stockDto.setAppItemId(f);
            }
            updateStockDtos.add(stockDto);
        });
        PrizeAdapter prizeAdapter = (PrizeAdapter)this.galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "PrizeAdapter");
        List<Object> collect2 = new ArrayList();
        if (CollectionUtils.isNotEmpty(collect4)) {
            ItemListParam i = new ItemListParam();
            i.setPageNo(Integer.valueOf(1));
            i.setPageSize(Integer.valueOf(100));
            i.setItemIds(new ArrayList(collect4));
            i.setBizType(bizType);
            i.setBizId(appId);
            List projectXItemDtos = prizeAdapter.itemList(i);
            if (CollectionUtils.isNotEmpty((Collection)projectXItemDtos)) {
                collect2 = projectXItemDtos.stream().map(p -> {
                    Long itemId = Objects.nonNull(p.getItemId()) ? p.getItemId() : (Objects.nonNull(p.getAppItemId()) ? p.getAppItemId() : 0L);
                    PrizeEntity prizeEntity = new PrizeEntity();
                    prizeEntity.setPrizeImg(p.getIcon());
                    prizeEntity.setSource(bizType);
                    prizeEntity.setRefId(itemId);
                    prizeEntity.setPrizeName(p.getItemName());
                    prizeEntity.setTotalStock(Long.valueOf(itemStock.getOrDefault(itemId.toString(), 0).longValue()));
                    prizeEntity.setUsedStock(Long.valueOf(itemStock.getOrDefault(itemId.toString(), 0).longValue()));
                    prizeEntity.setRefType(p.getItemType());
                    prizeEntity.setThirdAppId(appId);
                    prizeEntity.setPrizeType(PrizeTypeEnum.getByType((String)p.getItemType()).getCode());
                    return prizeEntity;
                }).collect(Collectors.toList());
            }
        }
        if (CollectionUtils.isNotEmpty(collect2)) {
            boolean b = this.prizeService.saveBatch(collect2);
            itemIdTypeToPrizeId.putAll(collect2.stream().collect(Collectors.toMap(p -> p.getRefId().toString() + p.getSource(), PrizeEntity::getId)));
        }
    }

    private void handleUpdateOption(List<OperationalOptionParam> operationalOptionParamList, List<UpdateStockDto> updateStockDtos, List<OperationalOptionParam> updateOption, List<OptionEntity> oldOption, Map<String, Long> itemIdTypeToPrizeId, List<OptionEntity> optionEntities) {
        updateOption.forEach(o -> {
            if (StringUtils.isNumeric((CharSequence)o.getItemId())) {
                o.setPrizeId(itemIdTypeToPrizeId.getOrDefault(o.getItemId() + o.getBizType(), 0L));
            }
        });
        List optionEntities1 = BeanUtils.copyList(updateOption, OptionEntity.class);
        List collect5 = optionEntities1.stream().map(OptionEntity::getPrizeId).collect(Collectors.toList());
        List<Long> updatePrizedOption = oldOption.stream().filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode())).filter(a -> operationalOptionParamList.stream().filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode())).anyMatch(b -> Objects.equals(a.getId(), b.getId()) && !Objects.equals(a.getPrizeId(), b.getPrizeId()))).map(OptionEntity::getPrizeId).collect(Collectors.toList());
        ArrayList<OptionEntity> delPrizes = new ArrayList<OptionEntity>();
        List collect6 = oldOption.stream().filter(a -> optionEntities1.stream().noneMatch(b -> Objects.equals(a.getId(), b.getId()))).map(c -> {
            if (!collect5.contains(c.getPrizeId())) {
                delPrizes.add((OptionEntity)c);
            }
            OptionEntity e = new OptionEntity();
            e.setId(c.getId());
            e.setDeleted(Integer.valueOf(1));
            return e;
        }).collect(Collectors.toList());
        this.handleDelPrize(updateStockDtos, updatePrizedOption, delPrizes);
        List collect7 = optionEntities1.stream().filter(a -> collect6.stream().noneMatch(c -> Objects.equals(a.getId(), c.getId()))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect6)) {
            optionEntities.addAll(collect6);
        }
        if (CollectionUtils.isNotEmpty(collect7)) {
            optionEntities.addAll(collect7);
        }
    }

    private void handleDelPrize(List<UpdateStockDto> updateStockDtos, List<Long> updatePrizedOption, List<OptionEntity> delPrizes) {
        List prizeIds = delPrizes.stream().map(OptionEntity::getPrizeId).collect(Collectors.toList());
        Map<Long, Integer> collect2 = delPrizes.stream().filter(o -> Objects.equals(o.getOptionType(), OptionTypeEnum.PROCUREMENT.getCode())).collect(Collectors.groupingBy(OptionEntity::getPrizeId, Collectors.summingInt(OptionEntity::getTotalStock)));
        prizeIds.addAll(updatePrizedOption);
        if (CollectionUtils.isEmpty(prizeIds)) {
            return;
        }
        List list2 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.prizeService.lambdaQuery().in(CollectionUtils.isNotEmpty(prizeIds), PrizeEntity::getId, prizeIds)).eq(PrizeEntity::getDeleted, (Object)DeleteFieldTypeEnum.UN_DELETE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            List prizeEntities = list2.stream().map(l -> {
                if (Objects.isNull(l.getTotalStock())) {
                    return null;
                }
                PrizeEntity prizeEntity = new PrizeEntity();
                prizeEntity.setId(l.getId());
                prizeEntity.setTotalStock(Long.valueOf(l.getTotalStock() - (long)collect2.getOrDefault(l.getId(), 0).intValue()));
                prizeEntity.setUsedStock(Long.valueOf(l.getUsedStock() - (long)collect2.getOrDefault(l.getId(), 0).intValue()));
                if (Objects.equals(l.getTotalStock(), 0L)) {
                    return prizeEntity;
                }
                UpdateStockDto stockDto = new UpdateStockDto();
                stockDto.setType(1);
                stockDto.setNum(l.getTotalStock());
                if (Objects.equals(l.getSource(), ItemBizTypeEnum.CREDIT.getCode())) {
                    stockDto.setItemId(l.getRefId());
                } else if (Objects.equals(l.getSource(), ItemBizTypeEnum.OWN.getCode())) {
                    stockDto.setAppItemId(l.getRefId());
                }
                updateStockDtos.add(stockDto);
                return prizeEntity;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.prizeService.updateBatchById(prizeEntities);
        }
    }

    private void handleAllDelOption(List<UpdateStockDto> updateStockDtos, List<OptionEntity> oldOption, List<OptionEntity> optionEntities) {
        List collect6 = oldOption.stream().map(c -> {
            OptionEntity e = new OptionEntity();
            e.setId(c.getId());
            e.setDeleted(Integer.valueOf(1));
            return e;
        }).collect(Collectors.toList());
        this.handleDelPrize(updateStockDtos, new ArrayList<Long>(), oldOption);
        if (CollectionUtils.isNotEmpty(collect6)) {
            return;
        }
        optionEntities.addAll(collect6);
    }

    private void handleStock(Long appId, List<UpdateStockDto> updateStockDtos, StockAdapter stockAdapter, Map<String, List<OperationalOptionParam>> itemIdToMap) throws BizException {
        if (CollectionUtils.isEmpty(updateStockDtos)) {
            return;
        }
        List failStockDtos = stockAdapter.batchDeductStock(appId.toString(), updateStockDtos);
        if (CollectionUtils.isEmpty((Collection)failStockDtos)) {
            return;
        }
        ArrayList names = new ArrayList();
        failStockDtos.forEach(f -> {
            List ps = itemIdToMap.getOrDefault(f.getItemId() + ItemBizTypeEnum.CREDIT.getCode().toString(), itemIdToMap.getOrDefault(f.getAppItemId() + ItemBizTypeEnum.OWN.getCode().toString(), null));
            if (CollectionUtils.isEmpty((Collection)ps)) {
                return;
            }
            names.addAll(ps.stream().map(OperationalOptionParam::getOptionName).collect(Collectors.toList()));
        });
        throw new BizRuntimeException((BizError)PlatformCoreErrorEnum.PRIZE_STOCK_NOT_ENOUGH.setDesc(String.format("\u5956\u54c1[%s]\u5e93\u5b58\u64cd\u4f5c\u5931\u8d25", names)));
    }

    @Override
    public List<OptionEntity> listOptionByRuIds(Long projectId, List<String> ruIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(OptionEntity::getProjectId, (Object)projectId)).eq(OptionEntity::getDeleted, (Object)DeleteFieldTypeEnum.UN_DELETE.getCode());
        return this.optionService.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean batchDelOptions(Long projectId, List<OptionEntity> entities) {
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(u -> u.setDeleted(DeleteFieldTypeEnum.DELETE.getCode()));
        }
        return this.optionService.updateBatchById(entities);
    }

    @Override
    public List<OptionEntity> listAllOptions(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(OptionEntity::getProjectId, (Object)projectId)).eq(OptionEntity::getDeleted, (Object)DeleteFieldTypeEnum.UN_DELETE.getCode());
        return this.optionService.list((Wrapper)queryWrapper);
    }
}

