/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.SsoExtManager;
import cn.com.duiba.galaxy.console.model.vo.admin.AdminVo;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.LoginStateDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.hutool.core.bean.BeanUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SsoExtManagerImpl
implements SsoExtManager {
    private static final Logger log = LoggerFactory.getLogger(SsoExtManagerImpl.class);
    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private RemoteAdminService remoteAdminService;

    @Override
    public AdminVo getAdminInfo() {
        AdminDto admin;
        String ssoTicket = RequestTool.getCookie((String)"sso_ticket");
        LoginStateDto loginStateDto = this.remoteSSOService.verifyTicket(ssoTicket);
        Conditions.expectNotNull((Object)loginStateDto, (BizError)PlatformConsoleErrorEnum.SSO_LOGIN_VERIFY_FAIL);
        try {
            admin = this.remoteAdminService.findOneAdmin(loginStateDto.getAdminId());
        }
        catch (BizException e) {
            throw new BizRuntimeException((BizError)PlatformConsoleErrorEnum.THE_EMPLOYEE_HAS_LEFT);
        }
        return (AdminVo)BeanUtil.copyProperties((Object)admin, AdminVo.class, (String[])new String[0]);
    }
}

