/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.galaxy.basic.enums.PrototypeTypeEnum;
import cn.com.duiba.galaxy.basic.model.entity.PrototypeEntity;
import cn.com.duiba.galaxy.basic.model.entity.TemplateEntity;
import cn.com.duiba.galaxy.basic.model.jsonfield.ViewAttributesJson;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.basic.service.TemplateService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.enums.PrototypeStateEnum;
import cn.com.duiba.galaxy.console.enums.TemplateSyncStateEnum;
import cn.com.duiba.galaxy.console.enums.TemplateTypeEnum;
import cn.com.duiba.galaxy.console.manager.TemplateBackendManager;
import cn.com.duiba.galaxy.console.model.param.template.TemplatePageQueryParam;
import cn.com.duiba.galaxy.console.model.param.template.TemplateSaveParam;
import cn.com.duiba.galaxy.console.model.param.template.TemplateSyncParam;
import cn.com.duiba.galaxy.console.model.vo.PageList;
import cn.com.duiba.galaxy.console.model.vo.template.TemplateVo;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateBackendManagerImpl
implements TemplateBackendManager {
    private static final Logger log = LoggerFactory.getLogger(TemplateBackendManagerImpl.class);
    @Autowired
    private PrototypeService prototypeService;
    @Autowired
    private TemplateService templateService;
    @Resource
    private RemoteAppService remoteAppService;

    @Override
    public TemplateVo getById(Long id) {
        TemplateEntity template = (TemplateEntity)this.templateService.getById((Serializable)id);
        Conditions.expectNotNull((Object)template, (BizError)PlatformConsoleErrorEnum.TEMPLATE_NOT_FOUND);
        PrototypeEntity prototype = (PrototypeEntity)this.prototypeService.getById((Serializable)template.getPrototypeId());
        Conditions.expectNotNull((Object)prototype, (BizError)PlatformConsoleErrorEnum.TEMPLATE_PROTOTYPE_NOT_FOUND);
        TemplateVo templateVO = (TemplateVo)BeanUtil.copyProperties((Object)template, TemplateVo.class, (String[])new String[0]);
        templateVO.setPrototypeState(prototype.getState());
        templateVO.setTemplatePoster(Optional.of(prototype).map(PrototypeEntity::getViewAttributes).map(ViewAttributesJson::getTemplatePoster).orElse(""));
        return templateVO;
    }

    @Override
    public PageList<TemplateVo> list(TemplatePageQueryParam param) {
        LambdaQueryWrapper templateQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(StringUtils.isNotBlank((CharSequence)param.getTemplateName()), TemplateEntity::getTemplateName, (Object)param.getTemplateName())).eq(Objects.nonNull(param.getTemplateType()), TemplateEntity::getTemplateType, (Object)param.getTemplateType())).orderByDesc(TemplateEntity::getId);
        IPage page = this.templateService.page((IPage)new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue()), (Wrapper)templateQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return PageList.of(page.getTotal(), page.getSize(), Collections.emptyList());
        }
        List prototypeIdList = page.getRecords().stream().map(TemplateEntity::getPrototypeId).collect(Collectors.toList());
        List prototypeList = this.prototypeService.listByIds(prototypeIdList);
        Map templatePosterMap = prototypeList.stream().collect(Collectors.toMap(PrototypeEntity::getId, Function.identity(), (o, n) -> n));
        return PageList.of(page, result -> {
            TemplateVo templateVO = (TemplateVo)BeanUtil.copyProperties((Object)result, TemplateVo.class, (String[])new String[0]);
            Optional.ofNullable(templatePosterMap.get(templateVO.getPrototypeId())).ifPresent(prototype -> {
                templateVO.setPrototypeState(prototype.getState());
                templateVO.setTemplatePoster(Optional.of(prototype).map(PrototypeEntity::getViewAttributes).map(ViewAttributesJson::getTemplatePoster).orElse(""));
            });
            return templateVO;
        });
    }

    @Override
    public Boolean save(TemplateSaveParam param) {
        Conditions.expectNotNull((Object)((Object)TemplateTypeEnum.valueOfType(param.getTemplateType())), (BizError)PlatformConsoleErrorEnum.TEMPLATE_TYPE_NOT_FOUND);
        PrototypeEntity prototype = (PrototypeEntity)this.prototypeService.getById((Serializable)param.getPrototypeId());
        Conditions.expectNotNull((Object)prototype, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_FOUND);
        Conditions.expectTrue((boolean)Objects.equals(prototype.getState(), PrototypeStateEnum.ENABLED.getCode()), (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_ENABLED);
        Conditions.expectTrue((boolean)Objects.equals(prototype.getPrototypeType(), PrototypeTypeEnum.TEMPLATE.getCode()), (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_MATCH);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TemplateEntity::getPrototypeId, (Object)param.getPrototypeId());
        Conditions.expectTrue((this.templateService.count((Wrapper)queryWrapper) <= 0L ? 1 : 0) != 0, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_HAS_BEEN_ASSOCIATED);
        TemplateEntity entity = (TemplateEntity)BeanUtil.copyProperties((Object)param, TemplateEntity.class, (String[])new String[0]);
        entity.setTemplateName(prototype.getPrototypeName());
        return this.templateService.save((Object)entity);
    }

    @Override
    public Boolean sync(TemplateSyncParam param) {
        TemplateEntity template = (TemplateEntity)this.templateService.getById((Serializable)param.getTemplateId());
        Conditions.expectNotNull((Object)template, (BizError)PlatformConsoleErrorEnum.TEMPLATE_NOT_FOUND);
        TemplateSyncStateEnum paramTypeEnum = TemplateSyncStateEnum.valueOfType(param.getSyncType());
        TemplateSyncStateEnum currentTypeEnum = TemplateSyncStateEnum.valueOfType(template.getSyncType());
        Conditions.expectFalse((paramTypeEnum == currentTypeEnum && (paramTypeEnum == TemplateSyncStateEnum.INIT || paramTypeEnum == TemplateSyncStateEnum.FULL_SYNC) ? 1 : 0) != 0, (BizError)PlatformConsoleErrorEnum.INVALID_CHANGE);
        PrototypeEntity prototype = (PrototypeEntity)this.prototypeService.getById((Serializable)template.getPrototypeId());
        Conditions.expectNotNull((Object)prototype, (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_FOUND);
        Conditions.expectTrue((boolean)Objects.equals(prototype.getState(), PrototypeStateEnum.ENABLED.getCode()), (BizError)PlatformConsoleErrorEnum.PROTOTYPE_NOT_ENABLED);
        String appIdListStr = null;
        if (paramTypeEnum == TemplateSyncStateEnum.LOCAL_SYNC) {
            List appIdList = param.getSyncApp().stream().map(Long::valueOf).collect(Collectors.toList());
            List appIdListFromDb = this.remoteAppService.findByIds(appIdList).stream().map(AppSimpleDto::getId).collect(Collectors.toList());
            if (appIdList.size() != appIdListFromDb.size()) {
                List subtract = (List)CollectionUtils.subtract(appIdList, appIdListFromDb);
                log.warn("\u540c\u6b65\u6a21\u7248\u5931\u8d25\uff0c\u4ee5\u4e0bapp\u4fe1\u606f\u672a\u68c0\u7d22\u5230\uff1a{}", (Object)subtract);
                throw new BizRuntimeException(PlatformConsoleErrorEnum.INVALID_APP.setDesc(String.format("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5e94\u7528ID\uff0c\u5e94\u7528ID%s\u4e0d\u5b58\u5728", subtract)));
            }
            appIdListStr = Optional.ofNullable(param.getSyncApp()).map(Object::toString).orElse(null);
        }
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(TemplateEntity::getId, (Object)param.getTemplateId())).set(TemplateEntity::getSyncType, (Object)param.getSyncType())).set(TemplateEntity::getSyncApp, appIdListStr);
        return this.templateService.update(null, (Wrapper)lambdaUpdateWrapper);
    }
}

