/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.jiuli.client.JiuliFileClient;
import cn.com.duiba.cloud.jiuli.client.domian.params.PutFileParams;
import cn.com.duiba.cloud.jiuli.client.domian.result.PutFileResult;
import cn.com.duiba.cloud.jiuli.client.service.JiuliFileClientManager;
import cn.com.duiba.galaxy.console.config.OssConfig;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.FileUploadManager;
import cn.com.duiba.galaxy.console.util.FileIDGeneratorUtils;
import cn.com.duiba.galaxy.core.annotation.ConditionalOnBizScene;
import cn.com.duiba.galaxy.core.enums.BizSceneEnum;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.wolf.utils.DateUtils;
import java.io.IOException;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ConditionalOnBizScene(value=BizSceneEnum.CREDITS_MALL_V1)
public class CreditsFileUploadManagerImpl
implements FileUploadManager {
    private static final Logger log = LoggerFactory.getLogger(CreditsFileUploadManagerImpl.class);
    @Autowired
    private OssConfig ossConfig;
    private static final int MAX_M = 20;
    private static final String DUIBA_GALAXY_CONSOLE = "duibaGalaxyConsole";
    @Resource
    private JiuliFileClientManager jiuliFileClientManager;

    @Override
    public String uploadFile(MultipartFile file) throws IOException, BizException {
        Conditions.expectTrue((boolean)CreditsFileUploadManagerImpl.checkFileSize(file.getSize(), 20, "M"), (BizError)PlatformConsoleErrorEnum.FILE_SIZE_LIMIT);
        String originalFilename = file.getOriginalFilename();
        Conditions.expectNotNull((Object)originalFilename, (BizError)PlatformConsoleErrorEnum.FILE_TYPE_NULL_ERROR);
        String fileType = originalFilename.substring(originalFilename.lastIndexOf(46) + 1);
        String fileName = FileIDGeneratorUtils.getRandomString(10) + "." + fileType;
        String dateStr = DateUtils.getDayStr((Date)new Date());
        String path = String.format("duibaGalaxyConsole/%s/%s", dateStr, fileName);
        JiuliFileClient client = this.jiuliFileClientManager.getFileClient(this.ossConfig.getSpaceKey());
        PutFileParams putFileParams = new PutFileParams();
        putFileParams.setFileId(path);
        PutFileResult putFileResult = client.putFile(putFileParams, file.getInputStream());
        return putFileResult.getAccessUrl();
    }

    private static boolean checkFileSize(Long len, int size, String unit) {
        double fileSize = 0.0;
        if ("B".equals(unit)) {
            fileSize = len.longValue();
        } else if ("K".equals(unit)) {
            fileSize = (double)len.longValue() / 1024.0;
        } else if ("M".equals(unit)) {
            fileSize = (double)len.longValue() / 1048576.0;
        } else if ("G".equals(unit)) {
            fileSize = (double)len.longValue() / 1.073741824E9;
        }
        return fileSize < (double)size;
    }
}

