/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl.credits;

import cn.com.duiba.galaxy.adapter.base.adapter.PrizeAdapter;
import cn.com.duiba.galaxy.adapter.base.enums.AdapterTypeEnum;
import cn.com.duiba.galaxy.adapter.base.enums.ItemTypeEnum;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapterFactory;
import cn.com.duiba.galaxy.adapter.base.params.ItemListParam;
import cn.com.duiba.galaxy.console.manager.ItemManager;
import cn.com.duiba.galaxy.console.model.param.item.ItemListQueryParam;
import cn.com.duiba.galaxy.console.model.vo.item.ItemVo;
import cn.com.duiba.galaxy.core.annotation.ConditionalOnBizScene;
import cn.com.duiba.galaxy.core.enums.BizSceneEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnBizScene(value=BizSceneEnum.CREDITS_MALL_V1)
public class CreditsItemManagerImpl
implements ItemManager {
    @Autowired
    private GalaxyAdapterFactory<PrizeAdapter> galaxyAdapterFactory;

    @Override
    public List<ItemVo> listItem(ItemListQueryParam param) {
        PrizeAdapter adapter = (PrizeAdapter)this.galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "PrizeAdapter");
        ItemListParam p = new ItemListParam();
        p.setItemType(param.getItemType());
        p.setItemName(param.getItemName());
        p.setBizId(param.getBizId());
        p.setBizType(param.getBizType());
        p.setPageNo(param.getPageNum());
        p.setPageSize(param.getPageSize());
        p.setItemId(param.getItemId());
        List projectXItemDtos = adapter.itemList(p);
        if (CollectionUtils.isEmpty((Collection)projectXItemDtos)) {
            return new ArrayList<ItemVo>();
        }
        List<ItemVo> itemVos = projectXItemDtos.stream().map(i -> {
            ItemVo vo = new ItemVo();
            vo.setItemIcon(i.getIcon());
            vo.setItemName(i.getItemName());
            vo.setItemId(Objects.nonNull(i.getItemId()) ? i.getItemId().toString() : i.getAppItemId().toString());
            vo.setCostPrice(i.getActualPrice());
            vo.setItemType(Objects.nonNull(i.getItemType()) ? ItemTypeEnum.getByType((String)i.getItemType()).getCode() : null);
            vo.setItemSubType(i.getSubType());
            vo.setTotalStock(i.getStock());
            if (Objects.nonNull(i.getMultiSku())) {
                vo.setSpecificationType(i.getMultiSku() != false ? 2 : 1);
            }
            return vo;
        }).collect(Collectors.toList());
        return itemVos;
    }
}

