/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.credits.sdk.CreditTool;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.DomainConfigDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDomainConfigService;
import cn.com.duiba.galaxy.api.model.param.ProjectNewOrUpdateParam;
import cn.com.duiba.galaxy.basic.model.entity.ProjectEntity;
import cn.com.duiba.galaxy.basic.model.entity.PrototypeEntity;
import cn.com.duiba.galaxy.basic.model.entity.TemplateEntity;
import cn.com.duiba.galaxy.basic.service.ProjectExtService;
import cn.com.duiba.galaxy.basic.service.ProjectService;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.basic.service.TemplateService;
import cn.com.duiba.galaxy.basic.util.Environment;
import cn.com.duiba.galaxy.console.enums.IdentityTypeEnum;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.ProjectManager;
import cn.com.duiba.galaxy.console.manager.impl.AbstractProjectManagerImpl;
import cn.com.duiba.galaxy.console.model.param.project.ProjectNewParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectQueryParam;
import cn.com.duiba.galaxy.console.model.param.project.ProjectUpdateParam;
import cn.com.duiba.galaxy.console.model.vo.IdentityChildrenVo;
import cn.com.duiba.galaxy.console.model.vo.IdentityVo;
import cn.com.duiba.galaxy.console.model.vo.project.PageProjectVo;
import cn.com.duiba.galaxy.console.model.vo.project.ProjectListVo;
import cn.com.duiba.galaxy.core.annotation.ConditionalOnBizScene;
import cn.com.duiba.galaxy.core.enums.BizSceneEnum;
import cn.com.duiba.galaxy.core.enums.OpenbsStateEnum;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnBizScene(value=BizSceneEnum.CREDITS_MALL_V1)
public class CreditsProjectManagerImpl
extends AbstractProjectManagerImpl
implements ProjectManager {
    private static final Logger log = LoggerFactory.getLogger(CreditsProjectManagerImpl.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private PrototypeService prototypeService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private ProjectExtService projectExtService;
    @Resource
    private RemoteDomainConfigService remoteDomainConfigService;
    @Resource
    private RemoteAppService remoteAppService;

    @Override
    public Boolean updateAppId(Long projectId, Long appId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ProjectEntity::getId, (Object)projectId);
        updateWrapper.set(ProjectEntity::getAppId, (Object)appId);
        return this.projectService.update((Wrapper)updateWrapper);
    }

    @Override
    public PageProjectVo listProjects(ProjectQueryParam queryParam) {
        Page projectEntityPage = this.projectService.conditionAndPageQuery(queryParam.getPrototypeCondition(), queryParam.getProjectCondition(), queryParam.getProd(), queryParam.getOperator(), queryParam.getPageNum(), queryParam.getPageSize());
        PageProjectVo pageProjectVo = new PageProjectVo();
        if (projectEntityPage.getTotal() == 0L) {
            return pageProjectVo;
        }
        List projectEntities = projectEntityPage.getRecords();
        Map<Long, ProjectEntity> projectEntityMap = projectEntities.stream().collect(Collectors.toMap(ProjectEntity::getId, x -> x));
        Set prototypeIds = projectEntities.stream().map(ProjectEntity::getPrototypeId).collect(Collectors.toSet());
        List prototypeEntities = this.prototypeService.listPrototypeEntity(prototypeIds);
        Map<Long, PrototypeEntity> prototypeEntityMap = prototypeEntities.stream().collect(Collectors.toMap(PrototypeEntity::getId, s -> s));
        List projectListVos = BeanUtil.copyToList((Collection)projectEntityPage.getRecords(), ProjectListVo.class);
        for (ProjectListVo projectListVo : projectListVos) {
            PrototypeEntity prototypeEntity = prototypeEntityMap.get(projectListVo.getPrototypeId());
            projectListVo.setPrototypeName(prototypeEntity.getPrototypeName());
            projectListVo.setPrototypeType(prototypeEntity.getPrototypeType());
            ProjectEntity projectEntity = projectEntityMap.get(projectListVo.getId());
            projectListVo.setEnableOpenBs(Objects.equals(projectEntity.getOpenbs(), OpenbsStateEnum.CLOSE.getCode()));
            projectListVo.setProd(projectEntity.getProd() == 1);
        }
        projectListVos.forEach(u -> u.setPrototypeName(String.valueOf(((PrototypeEntity)prototypeEntityMap.get(u.getPrototypeId())).getPrototypeName())));
        pageProjectVo.setTotalCount(projectEntityPage.getTotal());
        pageProjectVo.setList(projectListVos);
        return pageProjectVo;
    }

    @Override
    @Transactional
    public Long createForMall(ProjectNewOrUpdateParam param) throws BizException {
        Long projectId = param.getId();
        if (Objects.isNull(projectId)) {
            TemplateEntity template = this.templateService.listByAppId(param.getAppId()).stream().filter(v -> Objects.equals(param.getTemplateId(), v.getId())).findFirst().orElse(null);
            Conditions.expectNotNull((Object)template, (BizError)PlatformConsoleErrorEnum.TEMPLATE_NOT_FOUND);
            projectId = this.newProject((ProjectNewParam)BeanUtil.copyProperties((Object)param, ProjectNewParam.class, (String[])new String[0]));
            Conditions.expectNotNull((Object)projectId, (BizError)PlatformConsoleErrorEnum.NEW_PROJECT_ERROR);
            ProjectEntity projectEntity = (ProjectEntity)this.projectService.getById((Serializable)projectId);
            param.setId(projectId);
            param.setGmtModified(projectEntity.getGmtModified());
            this.updateAppId(projectId, param.getAppId());
        }
        Conditions.expectTrue((boolean)this.updateForMall(param), (BizError)PlatformConsoleErrorEnum.NEW_PROJECT_ERROR);
        return projectId;
    }

    @Override
    public Boolean updateForMall(ProjectNewOrUpdateParam param) throws BizException {
        return this.updateProject((ProjectUpdateParam)BeanUtil.copyProperties((Object)param, ProjectUpdateParam.class, (String[])new String[0]));
    }

    @Override
    public String getIndexUrl(Long projectId, Long appId) {
        DubboResult domainConfig = this.remoteDomainConfigService.findDomainConfig(appId);
        DomainConfigDto config = (DomainConfigDto)domainConfig.getResult();
        return StringUtils.join((Object[])new Serializable[]{this.getScheme(), config.getActivityDomain(), "/galaxy/app/project/", projectId, "/index.html"});
    }

    @Override
    public IdentityVo listAllIdentityByType(Integer type, Long appIp) {
        IdentityVo identityVo = new IdentityVo();
        identityVo.setType(type);
        identityVo.setName(IdentityTypeEnum.getIdentityTypeEnumByCode(type).getDesc());
        if (Objects.equals(type, IdentityTypeEnum.MEMBER_LEVEL.getCode())) {
            DubboResult result = this.remoteAppService.getSimpleApp(appIp);
            if (result.isSuccess()) {
                AppSimpleDto dto = (AppSimpleDto)result.getResult();
                String vipLevelConfig = dto.getVipLevelConfig();
                List childrenVos = JSONObject.parseArray((String)vipLevelConfig, IdentityChildrenVo.class);
                identityVo.setChildrenList(childrenVos);
                return identityVo;
            }
        } else if (Objects.equals(type, IdentityTypeEnum.USER_TAG.getCode())) {
            // empty if block
        }
        return identityVo;
    }

    @Override
    public String getPreviewUrl(Long projectId) {
        ProjectEntity projectEntity = (ProjectEntity)this.projectService.getById((Serializable)projectId);
        Conditions.expectNotNull((Object)projectEntity, (BizError)PlatformConsoleErrorEnum.NULL_PROJECT);
        Conditions.expectNotNull((Object)projectEntity.getAppId(), (BizError)PlatformConsoleErrorEnum.NOT_DIRECTED_APP);
        AppSimpleDto app = Optional.ofNullable(this.remoteAppService.getSimpleApp(projectEntity.getAppId())).map(DubboResult::getResult).orElseThrow(() -> new BizRuntimeException((BizError)PlatformConsoleErrorEnum.APP_NOT_FOUNT));
        Long appId = app.getId();
        DomainConfigDto domian = Optional.ofNullable(this.remoteDomainConfigService.findDomainConfig(appId)).map(DubboResult::getResult).orElseThrow(() -> new BizRuntimeException((BizError)PlatformConsoleErrorEnum.DOMIAN_NOT_FOUND));
        HashMap params = Maps.newHashMap();
        params.put("uid", "duiba-preview-user");
        params.put("timestamp", Long.toString(System.currentTimeMillis()));
        params.put("redirect", this.getIndexUrl(projectId, appId));
        return new CreditTool(app.getAppKey(), app.getAppSecret()).buildUrlWithSign(String.format("%s%s/autoLogin/autologin?", this.getScheme(), domian.getActivityDomain()), (Map)params);
    }

    private String getScheme() {
        return Environment.isProdEnv() ? "https:" : "http:";
    }
}

