/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.manager.impl.credits;

import cn.com.duiba.galaxy.console.manager.impl.AbstractRegionManagerImpl;
import cn.com.duiba.galaxy.console.model.vo.RegionVo;
import cn.com.duiba.galaxy.core.annotation.ConditionalOnBizScene;
import cn.com.duiba.galaxy.core.enums.BizSceneEnum;
import cn.com.duiba.geo.api.dto.AdministrativeDivisionDto;
import cn.com.duiba.geo.api.remoteservice.RemoteAdministrativeDivisionService;
import cn.hutool.core.bean.BeanUtil;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnBizScene(value=BizSceneEnum.CREDITS_MALL_V1)
public class CreditsRegionManagerImpl
extends AbstractRegionManagerImpl {
    @Autowired
    private RemoteAdministrativeDivisionService remoteAdministrativeDivisionService;
    private static final String XINJIANGPREFIXCODE = "65";
    private static final String SPECIALPREFIXCODE = "6590";
    private static final String REGION = "region";
    private Cache<String, List<RegionVo>> regionCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(50L).build();

    @Override
    public List<RegionVo> getProvinceAndCity() {
        List cache = (List)this.regionCache.getIfPresent((Object)REGION);
        if (CollectionUtils.isNotEmpty((Collection)cache)) {
            return cache;
        }
        ArrayList regionVos = Lists.newArrayList();
        List provinceList = this.remoteAdministrativeDivisionService.findRegionDivision();
        if (CollectionUtils.isEmpty((Collection)provinceList)) {
            return regionVos;
        }
        provinceList.forEach(divisionDto -> {
            RegionVo regionVo = new RegionVo();
            regionVo.setAdCode(divisionDto.getAdCode());
            regionVo.setName(divisionDto.getName());
            List<AdministrativeDivisionDto> cityList = this.remoteAdministrativeDivisionService.findAdministrativeDivisionByParentAdCode(divisionDto.getAdCode());
            if (CollectionUtils.isNotEmpty((Collection)cityList)) {
                if (divisionDto.getAdCode().startsWith(XINJIANGPREFIXCODE)) {
                    cityList = this.removeSpecialXinJiang(cityList);
                }
                regionVo.setChildren(BeanUtil.copyToList(cityList, RegionVo.class));
            }
            regionVos.add(regionVo);
        });
        this.regionCache.put((Object)REGION, (Object)regionVos);
        return regionVos;
    }

    public List<AdministrativeDivisionDto> removeSpecialXinJiang(List<AdministrativeDivisionDto> cityList) {
        ArrayList administrativeDivisionDtos = Lists.newArrayList();
        for (AdministrativeDivisionDto administrativeDivisionDto : cityList) {
            if (administrativeDivisionDto.getAdCode().startsWith(SPECIALPREFIXCODE)) continue;
            administrativeDivisionDtos.add(administrativeDivisionDto);
        }
        return administrativeDivisionDtos;
    }
}

