/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.model.vo;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PageList<T>
implements Serializable {
    private static final long serialVersionUID = 5001287295240910627L;
    private List<T> list;
    private Long totalCount;
    private Long totalPages;

    public static <T> PageList<T> of(long totalCount, long pageSize, List<T> list) {
        long totalPages = PageList.getTotalPages(totalCount, pageSize);
        return new PageList<T>(list, totalCount, totalPages);
    }

    public static <T, R> PageList<R> of(IPage<T> page, Class<R> destClass) {
        long totalCount = page.getTotal();
        long pageSize = page.getSize();
        long totalPages = PageList.getTotalPages(totalCount, pageSize);
        return new PageList<T>(BeanUtil.copyToList((Collection)page.getRecords(), destClass), totalCount, totalPages);
    }

    public static <T, R> PageList<R> of(IPage<T> page, Function<? super T, ? extends R> mapper) {
        long totalCount = page.getTotal();
        long pageSize = page.getSize();
        long totalPages = PageList.getTotalPages(totalCount, pageSize);
        List list = page.getRecords().stream().map(mapper).collect(Collectors.toList());
        return new PageList(list, totalCount, totalPages);
    }

    private static long getTotalPages(long totalCount, long pageSize) {
        if (pageSize == 0L) {
            return 0L;
        }
        long totalPages = totalCount / pageSize;
        if (totalCount % pageSize != 0L) {
            ++totalPages;
        }
        return totalPages;
    }

    public List<T> getList() {
        return this.list;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public Long getTotalPages() {
        return this.totalPages;
    }

    public PageList(List<T> list, Long totalCount, Long totalPages) {
        this.list = list;
        this.totalCount = totalCount;
        this.totalPages = totalPages;
    }
}

