/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.EnumDto;
import cn.com.duiba.galaxy.api.remote.RemoteCommonBackendService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.CommonBackendManager;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.hutool.core.bean.BeanUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteCommonBackendServiceImpl
implements RemoteCommonBackendService {
    private static final Logger log = LoggerFactory.getLogger(RemoteCommonBackendServiceImpl.class);
    @Autowired
    private CommonBackendManager commonBackendManager;

    public List<EnumDto> getEnumByName(String name) throws BizException {
        try {
            return BeanUtil.copyToList(this.commonBackendManager.getEnumByName(name), EnumDto.class);
        }
        catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        }
        catch (Exception e) {
            log.error("Exception [{}]\nname={}:", new Object[]{e.getMessage(), name, e});
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }
}

