/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.CreditsResponse;
import cn.com.duiba.galaxy.api.remote.RemoteGalaxyNotifyCreditsService;
import cn.com.duiba.galaxy.basic.model.entity.migration.CreditsRecordEntity;
import cn.com.duiba.galaxy.console.enums.TicketRecordExtraType;
import cn.com.duiba.galaxy.core.service.credits.CreditsService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteGalaxyNotifyCreditsServiceImpl
implements RemoteGalaxyNotifyCreditsService {
    private static final Logger log = LoggerFactory.getLogger(RemoteGalaxyNotifyCreditsServiceImpl.class);
    private static final String OK = "ok";
    private static final String FAIL = "fail";
    @Resource
    private CreditsService creditsService;

    public void creditsCallback(CreditsResponse resp) throws BizException {
        if (resp == null) {
            throw new BizException("params is null");
        }
        if (StringUtils.isEmpty((CharSequence)resp.getOrderNum())) {
            throw new BizException("orderNum is null");
        }
        if (StringUtils.isEmpty((CharSequence)resp.getStatus())) {
            throw new BizException("status is null");
        }
        try {
            Integer status = null;
            CreditsRecordEntity creditsRecordEntity = this.creditsService.find(resp.getOrderNum());
            String extra = creditsRecordEntity.getExtra();
            if (OK.equalsIgnoreCase(resp.getStatus())) {
                status = CreditsRecordEntity.SUCCESS;
            } else if (FAIL.equalsIgnoreCase(resp.getStatus())) {
                status = CreditsRecordEntity.FAIL;
                JSONObject extraJsonObject = StringUtils.isNotBlank((CharSequence)extra) ? JSON.parseObject((String)extra) : new JSONObject();
                extraJsonObject.put(TicketRecordExtraType.THIRDPARTY_CREDIT_FAIL_RESP.getKey(), (Object)resp.getResponseBody());
                extra = extraJsonObject.toJSONString();
            }
            this.creditsService.updateStatus(resp.getOrderNum(), status, resp.getBizId(), extra);
        }
        catch (Exception e) {
            log.error("creditsCallback", (Throwable)e);
            throw new BizException("\u6263\u79ef\u5206\u56de\u8c03\u5f02\u5e38" + e.getMessage());
        }
    }
}

