/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.galaxy.adapter.base.adapter.PrizeAdapter;
import cn.com.duiba.galaxy.adapter.base.enums.AdapterTypeEnum;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapter;
import cn.com.duiba.galaxy.adapter.base.handler.GalaxyAdapterFactory;
import cn.com.duiba.galaxy.adapter.base.params.ItemListParam;
import cn.com.duiba.galaxy.api.model.dto.RemoteProjectXItemDto;
import cn.com.duiba.galaxy.api.model.param.RemoteItemListParam;
import cn.com.duiba.galaxy.api.remote.RemotePrizeService;
import cn.com.duiba.galaxy.basic.model.entity.migration.UserPrizeRecordEntity;
import cn.com.duiba.galaxy.basic.service.migration.BaseRepository;
import cn.com.duiba.galaxy.basic.service.migration.UserPrizeRepository;
import cn.com.duiba.galaxy.core.service.base.UserPrizeRecordService;
import cn.com.duiba.galaxy.sdk.logger.BuriedPointInfoEnum;
import cn.com.duiba.galaxy.sdk.logger.BuriedPointService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemotePrizeServiceImpl
implements RemotePrizeService {
    private static final Logger log = LoggerFactory.getLogger(RemotePrizeServiceImpl.class);
    @Resource
    private UserPrizeRecordService userPrizeRecordService;
    @Resource
    private UserPrizeRepository userPrizeRepository;
    @Resource
    private BuriedPointService buriedPointService;
    @Resource
    private GalaxyAdapterFactory<GalaxyAdapter> galaxyAdapterFactory;

    public void updatePrizeStatus(String extra, Long orderNo, Integer status) {
        log.info("\u53d1\u5956\u72b6\u6001\u56de\u8c03 {} {} {}", new Object[]{extra, orderNo, status});
        if (StringUtils.isBlank((CharSequence)extra) && !JSONValidator.from((String)extra).validate()) {
            log.warn("\u53d1\u5956\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25");
            return;
        }
        JSONObject extraJson = JSON.parseObject((String)extra);
        UserPrizeRecordEntity entity = this.userPrizeRepository.find(extraJson.getLong("projectId"), orderNo);
        if (entity == null) {
            log.warn("\u53d1\u5956\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c\u6ca1\u6709\u5bf9\u5e94\u5956\u54c1\u8bb0\u5f55");
            return;
        }
        entity.setDrawStatus(status);
        this.userPrizeRecordService.update(entity);
        String tableSuffix = BaseRepository.getTableSuffix((Long)entity.getProjectId());
        this.buriedPointService.put(BuriedPointInfoEnum.EventType.ACTIVITY_AWARD_RECEIVE.builder(new Object[]{tableSuffix + "_" + entity.getId(), entity.getOptionId()}));
    }

    public List<RemoteProjectXItemDto> itemList(RemoteItemListParam itemListParam) {
        PrizeAdapter prizeAdapter = (PrizeAdapter)this.galaxyAdapterFactory.getAdapterByType(AdapterTypeEnum.CREDIT, "PrizeAdapter");
        return BeanUtils.copyList((List)prizeAdapter.itemList((ItemListParam)BeanUtils.copy((Object)itemListParam, ItemListParam.class)), RemoteProjectXItemDto.class);
    }
}

