/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.ProjectDto;
import cn.com.duiba.galaxy.api.model.param.ProjectNewOrUpdateParam;
import cn.com.duiba.galaxy.api.remote.RemoteProjectBackendService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.ProjectManager;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteProjectBackendServiceImpl
implements RemoteProjectBackendService {
    private static final Logger log = LoggerFactory.getLogger(RemoteProjectBackendServiceImpl.class);
    @Resource
    private ProjectManager projectManager;

    public Long createForMall(ProjectNewOrUpdateParam param) throws BizException {
        try {
            return this.projectManager.createForMall(param);
        }
        catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        }
        catch (Exception e) {
            log.error("Exception [{}]\nparam={}:", new Object[]{e.getMessage(), JSON.toJSONString((Object)param), e});
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    public Boolean updateForMall(ProjectNewOrUpdateParam param) throws BizException {
        try {
            return this.projectManager.updateForMall(param);
        }
        catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        }
        catch (Exception e) {
            log.error("Exception [{}]\nparam={}:", new Object[]{e.getMessage(), JSON.toJSONString((Object)param), e});
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    public ProjectDto getById(Long id) throws BizException {
        try {
            return (ProjectDto)BeanUtil.copyProperties((Object)this.projectManager.getProjectByProjectId(id), ProjectDto.class, (String[])new String[0]);
        }
        catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        }
        catch (Exception e) {
            log.error("Exception [{}]\nid={}:", new Object[]{e.getMessage(), id, e});
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    public Boolean updateState(Long projectId, Integer state) throws BizException {
        try {
            return this.projectManager.updateState(projectId, state);
        }
        catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        }
        catch (Exception e) {
            log.error("Exception [{}]\nprojectId={},state={}:", new Object[]{e.getMessage(), projectId, state, e});
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    public ProjectDto getReadyCopyProject(Long projectId) {
        return (ProjectDto)BeanUtil.copyProperties((Object)this.projectManager.getReadyCopyProject(projectId), ProjectDto.class, (String[])new String[0]);
    }
}

