/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.SpDto;
import cn.com.duiba.galaxy.api.remote.RemoteSpBackendService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.console.manager.SpManager;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.hutool.core.bean.BeanUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteSpBackendServiceImpl
implements RemoteSpBackendService {
    private static final Logger log = LoggerFactory.getLogger(RemoteSpBackendServiceImpl.class);
    @Autowired
    private SpManager spManager;

    public List<SpDto> listByPrototypeId(Long prototypeId) throws BizException {
        try {
            return BeanUtil.copyToList(this.spManager.listAllSps(prototypeId), SpDto.class);
        }
        catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        }
        catch (Exception e) {
            log.error("Exception [{}]\nprototypeId={}:", new Object[]{e.getMessage(), prototypeId, e});
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }
}

