/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.galaxy.api.model.dto.TemplateDto;
import cn.com.duiba.galaxy.api.remote.RemoteTemplateBackendService;
import cn.com.duiba.galaxy.basic.model.entity.PrototypeEntity;
import cn.com.duiba.galaxy.basic.model.entity.TemplateEntity;
import cn.com.duiba.galaxy.basic.model.jsonfield.ViewAttributesJson;
import cn.com.duiba.galaxy.basic.service.PrototypeService;
import cn.com.duiba.galaxy.basic.service.TemplateService;
import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteTemplateBackendServiceImpl
implements RemoteTemplateBackendService {
    private static final Logger log = LoggerFactory.getLogger(RemoteTemplateBackendServiceImpl.class);
    @Autowired
    private TemplateService templateService;
    @Autowired
    private PrototypeService prototypeService;

    public List<TemplateDto> listByAppId(Long appId) throws BizException {
        try {
            List list = this.templateService.listByAppId(appId);
            Conditions.expectTrue((boolean)CollectionUtils.isNotEmpty((Collection)list), (BizError)PlatformConsoleErrorEnum.NO_AUTH_TEMPLATE);
            List prototypeIdList = list.stream().map(TemplateEntity::getPrototypeId).collect(Collectors.toList());
            List prototypeList = this.prototypeService.listByIds(prototypeIdList);
            Map templatePosterMap = prototypeList.stream().collect(Collectors.toMap(PrototypeEntity::getId, Function.identity(), (o, n) -> n));
            List dtos = BeanUtil.copyToList((Collection)list, TemplateDto.class);
            dtos.forEach(v -> v.setTemplatePoster((String)Optional.ofNullable(templatePosterMap.get(v.getPrototypeId())).map(PrototypeEntity::getViewAttributes).map(ViewAttributesJson::getTemplatePoster).orElse(null)));
            return dtos;
        }
        catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        }
        catch (Exception e) {
            log.error("Exception [{}]\nappId={}:", new Object[]{e.getMessage(), appId, e});
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }

    public TemplateDto getByPrototypeId(Long prototypeId) throws BizException {
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TemplateEntity::getPrototypeId, (Object)prototypeId);
            return Optional.ofNullable(this.templateService.getOne((Wrapper)queryWrapper)).map(v -> (TemplateDto)BeanUtil.copyProperties((Object)v, TemplateDto.class, (String[])new String[0])).orElse(null);
        }
        catch (BizRuntimeException e) {
            throw new BizException(e.getMessage()).withCode(e.getCode());
        }
        catch (Exception e) {
            log.error("Exception [{}]\nprototypeId={}:", new Object[]{e.getMessage(), prototypeId, e});
            PlatformConsoleErrorEnum consoleEx = PlatformConsoleErrorEnum.SYSTEM_ERROR;
            throw new BizException(consoleEx.getDesc()).withCode(consoleEx.getCode());
        }
    }
}

