/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class Base64ToMultipartFileUtil
implements MultipartFile {
    private static final Logger log = LoggerFactory.getLogger(Base64ToMultipartFileUtil.class);
    private final byte[] imgContent;
    private final String header;

    public Base64ToMultipartFileUtil(byte[] imgContent, String header) {
        this.imgContent = imgContent;
        this.header = header.split(";")[0];
    }

    @NotNull
    public String getName() {
        return (double)System.currentTimeMillis() + Math.random() + "." + this.header.split("/")[1];
    }

    public String getOriginalFilename() {
        return (double)System.currentTimeMillis() + Math.random() * 10000.0 + "." + this.header.split("/")[1];
    }

    public String getContentType() {
        return this.header.split(":")[1];
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    @NotNull
    public byte[] getBytes() {
        return this.imgContent;
    }

    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.imgContent);
    }

    public void transferTo(@NotNull File dest) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(dest);){
            fileOutputStream.write(this.imgContent);
        }
        catch (Exception e) {
            log.error("execute Base64ToMultipartFileUtil.transferTo() failure!", (Throwable)e);
        }
    }
}

