/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.util;

import cn.com.duiba.galaxy.console.enums.PlatformConsoleErrorEnum;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class IdMaker {
    private static synchronized String generate4byteId() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[4];
        random.nextBytes(bytes);
        BigInteger bigint = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "X", bigint).toLowerCase();
    }

    public static String takeProjectId() {
        return (Object)((Object)IdType.p) + IdMaker.generate4byteId();
    }

    public static String takePlaywayId() {
        return (Object)((Object)IdType.w) + IdMaker.generate4byteId();
    }

    public static String takeActionId() {
        return (Object)((Object)IdType.a) + IdMaker.generate4byteId();
    }

    public static String takeRuleId() {
        return (Object)((Object)IdType.r) + IdMaker.generate4byteId();
    }

    public static String takePrizeId() {
        return (Object)((Object)IdType.g) + IdMaker.generate4byteId();
    }

    public static String takeOptionId() {
        return (Object)((Object)IdType.o) + IdMaker.generate4byteId();
    }

    public static String takeSkinId() {
        return (Object)((Object)IdType.f) + IdMaker.generate4byteId();
    }

    public static String takeTicketNum(String projectId) {
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            throw new BizRuntimeException((BizError)PlatformConsoleErrorEnum.NULL_PROJECT);
        }
        String uid = UUID.randomUUID().toString().replaceAll("-", "").substring(9);
        return projectId + uid;
    }

    public static enum IdType {
        p,
        w,
        a,
        r,
        o,
        g,
        f;

    }
}

