/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileToFileUtils {
    private static final Logger log = LoggerFactory.getLogger(MultipartFileToFileUtils.class);

    private MultipartFileToFileUtils() {
    }

    public static File multipartFileToFile(MultipartFile file) throws Exception {
        File toFile = null;
        if (file != null && file.getSize() > 0L) {
            InputStream ins = file.getInputStream();
            toFile = new File(Objects.requireNonNull(file.getOriginalFilename()));
            MultipartFileToFileUtils.inputStreamToFile(ins, toFile);
            ins.close();
        }
        return toFile;
    }

    private static void inputStreamToFile(InputStream ins, File file) {
        try {
            try (FileOutputStream os = new FileOutputStream(file);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                    ((OutputStream)os).write(buffer, 0, bytesRead);
                }
            }
            ins.close();
        }
        catch (Exception e) {
            log.error("execute MultipartFileToFile.inputStreamToFile() failure!", (Throwable)e);
        }
    }
}

