/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.console.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageUtils {
    private PackageUtils() {
    }

    public static Set<Class<?>> getClasses(String pack) throws IOException {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageDirName = pack.replace('.', '/');
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                PackageUtils.findClassesInPackageByFile(pack, filePath, recursive, classes);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            System.out.println("jar\u7c7b\u578b\u7684\u626b\u63cf");
            try {
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                PackageUtils.findClassesInPackageByJar(pack, entries, packageDirName, recursive, classes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    private static void findClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        if (Objects.nonNull(dirfiles)) {
            for (File file : dirfiles) {
                if (file.isDirectory()) {
                    PackageUtils.findClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                    continue;
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                try {
                    classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void findClassesInPackageByJar(String packageName, Enumeration<JarEntry> entries, String packageDirName, boolean recursive, Set<Class<?>> classes) {
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDirName)) continue;
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                packageName = name.substring(0, idx).replace('/', '.');
            }
            if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(packageName.length() + 1, name.length() - 6);
            try {
                classes.add(Class.forName(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            Set<Class<?>> classes = PackageUtils.getClasses("com.xx.xx.xx.xx");
            for (Class<?> c : classes) {
                Method[] m = c.getMethods();
                for (int i = 0; i < m.length; ++i) {
                    System.out.println("\"" + c.getName() + "." + m[i].getName() + "\",");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

