package cn.com.duiba.galaxy.sdk;

import cn.com.duiba.galaxy.sdk.api.prize.inner.Option;
import cn.com.duiba.galaxy.sdk.api.prize.inner.Option4Inner;
import cn.com.duiba.wolf.entity.Pair;

import java.util.Date;
import java.util.List;

/**
 * 星速台项目上下文
 * 所有扩展的内部上下文都需要继承该接口
 *
 * @author zhangruofan
 * @date 2020/04/21
 */
public interface ProjectContext {

    /**
     * 获取项目开始时间、结束时间
     */
    Pair<Date, Date> getProjectTime();

    /**
     * 获取当前活动appId
     * @return
     */
    Long getAppId();


    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     */
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     */
    String getStringVariable(String key);

    /**
     * 获取运营配置变量Date
     *
     * @param key 配置项Variable
     * @return 变量对应的Date值
     */
    Date getDateVariable(String key);


    /**
     * get project id
     *
     * @return project id
     */
    Long getProjectId();

    /**
     * get play way id
     *
     * @return play way id
     */
    String getPlaywayId();

    /**
     * get action id
     *
     * @return action id
     */
    String getActionId();

    /**
     * get send prize context
     *
     * @return send prize context
     */
    SendPrizeContext getSendPrizeContext();

    /**
     * 获取某个发奖策略下面的奖项列表
     *
     * @param strategyId 发奖策略id
     * @return list
     */
    List<Option> queryOptions(String strategyId);


    /**
     * 获取某个发奖策略下面的奖项列表(内部使用，会暴露中奖概率)
     *
     * @param strategyId 发奖策略id
     * @return list
     */
    List<Option4Inner> queryOptions4Inner(String strategyId);

//    /**
//     * getAttribute
//     * @return
//     */
//    Map<String, Object> getAttribute();
}
