package cn.com.duiba.galaxy.sdk;

import com.alibaba.fastjson.JSONObject;

/**
 * 发奖相关的上下文
 *
 * @author zhangruofan
 * @date 2020/04/21
 */
public interface SendPrizeContext {

    String PRIZE_COUNT_KEY = "prizeCount";

    String TICKET_NUM = "ticketNum";

    String DESCRIPTION = "description";

    String PROJECT_ID = "projectId";

    String EXPIRE_DATE = "expireDate";

    String EXT = "ext";

    String SOURCE = "source";

    /**
     * 增加积分描述key
     */
    String INCREASE_CREDITS_DESC_KEY = "desc";

    /**
     * 自定义加积分描述
     *
     * @param desc description
     */
    void setIncreaseCreditsDesc(String desc);

    /**
     * get increase credits desc
     *
     * @return desc
     */
    String getIncreaseCreditsDesc();


    /**
     * 设置发奖奖品个数
     *
     * @param prizeCount
     */
    void setPrizeCount(Integer prizeCount);

    /**
     * 获取发奖奖品个数
     *
     * @return
     */
    Integer getPrizeCount();


    Integer getPrizeCountWithNull();

    Integer getAndDeletePrizeCount();



    /**
     * 票据号
     *
     * @param ticketNum
     */
    void setTicketNum(String ticketNum);

    /**
     * 票据号
     *
     * @return
     */
    String getTicketNum();


    /**
     * 发奖描述（兑吧奖品）
     *
     * @param description
     */
    void setPrizeDescription(String description);

    /**
     * 发奖描述（兑吧奖品）
     *
     * @return
     */
    String getPrizeDescription();


    /**
     * 过期时间（兑吧奖品）
     *
     * @param description
     */
    void setExpireDate(String description);

    /**
     * 过期时间（兑吧奖品）
     *
     * @return
     */
    String getExpireDate();


    /**
     * 额外信息
     *
     * @param ext
     */
    void setExt(JSONObject ext);

    /**
     * 额外信息
     *
     * @return
     */
    JSONObject getExt();
}
