package cn.com.duiba.galaxy.sdk.api;


import cn.com.duiba.galaxy.sdk.UserRequestContext;

/**
 * 用户名单，包括白名单和黑名单api
 * @author zhangruofan
 * @date 2020/04/10
 */
public interface UserListServiceApi {

    /**
     * 新增活动黑名单接口
     *
     * @param context    context
     * @param bannedDesc 封禁原因描述(项目自定义)
     * @return true添加成功 false添加失败
     */
    Boolean addActivityBlack(UserRequestContext context, String bannedDesc);

    /**
     * 当前用户是否是黑名单用户
     *
     * @param userId 兑吧cid
     * @return true是黑名单用户，false不是黑名单用户
     */
    Boolean isActivityBlack(Long userId);
}
