package cn.com.duiba.galaxy.sdk.api.credits;

import cn.com.duiba.galaxy.sdk.api.credits.inner.CreditsRecord;
import cn.com.duiba.galaxy.sdk.api.credits.inner.DeductCreditsRequest;

import java.util.List;
import java.util.Optional;

/**
 * @author jiaxz
 * @since 2022-12-30
 */
public interface CreditsApi {
    /**
     * 发起扣积分，返回扣积分票据号
     */
    String deductCredits(DeductCreditsRequest request);

    /**
     * 扣积分门票是否可用
     *
     * @param ticketNum
     * @return
     */
    boolean isCreditsTicketUsable(String ticketNum, Long credits);

    /**
     * 使用扣积分门票
     *
     * @param ticketNum 票据单号
     * @return true:验证通过 false:验证失败
     */
    Boolean useCreditsTicket(String ticketNum);


    /**
     * 通过门票获取扣积分详情
     *
     * @param ticketNum 票据单号
     * @return creditsRecord
     */
    Optional<CreditsRecord> getCreditsTicket(String ticketNum);

    /**
     * 获取当前用户对应玩法动作下对应数量未使用的积分门票列表（quantity传null则表示不限定数量）
     *
     * @param playwayId
     * @param actionId
     * @param quantity
     * @return
     */
    List<CreditsRecord> findUnusedTicketList(String playwayId, String actionId, Long quantity);

}
