package cn.com.duiba.galaxy.sdk.api.pay;

import cn.com.duiba.galaxy.sdk.api.pay.third.api.AbcPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.AliPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.BocPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.CcbPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.CebXykPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.CiticPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.GdhxPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.IcbcElifePayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.IcbcPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.UnionPayApi;
import cn.com.duiba.galaxy.sdk.api.pay.third.api.WxPayApi;

/**
 * @author 刘佳辉
 * @since 2022/12/8
 */
public interface PayApi {

    /**
     * 微信支付 todo 未测试
     */
    WxPayApi getWxPayApi();

    /**
     * 支付宝支付 todo 未测试
     * @return
     */
    AliPayApi getAliPayApi();

    /**
     * 中国银行支付 todo 未测试
     * @return BocPayApi
     */
    BocPayApi getBocPayApi();

    /**
     * 农行支付 todo 未测试
     * @return
     */
    AbcPayApi getAbcPayApi();

    /**
     * 建行支付 todo 未测试
     * @return
     */
    CcbPayApi getCcbPayApi();

    /**
     * 中信银行支付 todo 未测试
     * @return
     */
    CiticPayApi getCiticPayApi();

    /**
     * 工行e支付H5 todo 未测试
     * @return
     */
    IcbcPayApi getIcbcPayApi();

    /**
     * 工行e生活支付（app端 && 微信小程序端） todo 未测试
     * @return
     */
    IcbcElifePayApi getIcbcElifePayApi();

    /**
     * 浙江银联支付 todo 未测试
     * @return
     */
    UnionPayApi getUnionPayApi();

    /**
     * 中国光大银行信用卡中心支付 todo 未测试
     *
     * @return
     */
    CebXykPayApi getCebXykPayApi();

    /**
     * 广东华兴银行支付 todo 未测试
     * @return
     */
    GdhxPayApi getGdhxPayApi();

}
