package cn.com.duiba.galaxy.sdk.api.pay.third.api;

import cn.com.duiba.galaxy.sdk.api.pay.third.ali.AliPayNotifyResp;
import cn.com.duiba.galaxy.sdk.api.pay.third.ali.AliWapPayReq;
import cn.com.duiba.galaxy.sdk.api.pay.third.ali.AliWapPayResp;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;

import java.util.Map;

/**
 * @author liugq
 * @date 2020/04/03
 */
public interface AliPayApi {


    /**
     * 发起支付宝wap支付
     * @param request
     @return
     */
    AliWapPayResp createWapPay(AliWapPayReq request) throws BizRuntimeException;

    /**
     * 支付订单状态查询
     * @param payRecordId
     * @return
     */
     int queryPayStatus(Long payRecordId) throws BizRuntimeException;
    /**
     * 支付结果通知
     * @param paramsMap
     *1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     *            Map<String, String> params = toMap(request);
     * 2.业务处理后需要返回给支付宝处理结果
     * 可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    AliPayNotifyResp payOrderNotify(Map<String,String> paramsMap)  throws BizRuntimeException;

}
