package cn.com.duiba.galaxy.sdk.api.pay.third.api;

import cn.com.duiba.galaxy.sdk.api.pay.third.boc.BocBaseRefundRequest;
import cn.com.duiba.galaxy.sdk.api.pay.third.boc.BocBaseRefundResponse;
import cn.com.duiba.galaxy.sdk.api.pay.third.boc.BocPayCenterChargeNotifyResponse;
import cn.com.duiba.galaxy.sdk.api.pay.third.boc.BocWapPayCenterChargeRequest;
import cn.com.duiba.galaxy.sdk.api.pay.third.boc.BocWapPayCenterChargeResponse;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;

import java.util.Map;

/**
 * @author zhangruofan
 * @date 2020/04/23
 */
public interface BocPayApi {
    /**
     * create boc charge
     * @param chargeRequest charge request
     * @return response
     * @throws BizRuntimeException 业务异常
     */
    BocWapPayCenterChargeResponse createBocCharge(BocWapPayCenterChargeRequest chargeRequest) throws BizRuntimeException;

    /**
     * 中国支付通知
     * @param map params
     * @return response
     */
    BocPayCenterChargeNotifyResponse orderNotify(Map<String, String> map) throws BizRuntimeException;

    /**
     * 中国支付发起退款
     * @param request
     * @return
     */
    BocBaseRefundResponse bocRefund(BocBaseRefundRequest request);

}
