package cn.com.duiba.galaxy.sdk.api.pay.third.api;

import cn.com.duiba.galaxy.sdk.api.pay.param.BaseRefundResp;
import cn.com.duiba.galaxy.sdk.api.pay.third.citic.CiticPayCenterCallbackNotifyResponse;
import cn.com.duiba.galaxy.sdk.api.pay.third.citic.CiticPayCenterChargeNotifyResponse;
import cn.com.duiba.galaxy.sdk.api.pay.third.citic.CiticPayCenterRefundRequest;
import cn.com.duiba.galaxy.sdk.api.pay.third.citic.CiticWapPayCenterChargeRequest;
import cn.com.duiba.galaxy.sdk.api.pay.third.citic.CiticWapPayCenterChargeResponse;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;


/**
 * Created by HePeng on 2020/11/05 14:57.
 */
public interface CiticPayApi {
    /**
     * 发起支付
     * @param chargeRequest
     * @return
     * @throws BizRuntimeException
     */
    CiticWapPayCenterChargeResponse createCiticCharge(CiticWapPayCenterChargeRequest chargeRequest) throws BizRuntimeException;

    /**
     * 查询支付结果
     * @param bizOrderNo
     * @param bizType
     * @return
     * @throws BizRuntimeException
     */
    CiticPayCenterChargeNotifyResponse queryOrderNotify(String bizOrderNo, Integer bizType) throws BizRuntimeException;

    /**
     * 发起退款
     * @param request
     * @return
     */
    BaseRefundResp citicRefund(CiticPayCenterRefundRequest request);


    /**
     * 后端回调通知
     *
     * @param content 开发者回调通知信息
     * @return
     */
    CiticPayCenterCallbackNotifyResponse callbackNotify(String content);
}
