package cn.com.duiba.galaxy.sdk.api.prize;

import cn.com.duiba.galaxy.sdk.api.prize.inner.StrategyResult;
import cn.com.duiba.galaxy.sdk.api.prize.inner.StrategyTypeEnum;
import cn.com.duiba.galaxy.sdk.api.prize.inner.UserSpRecordNew;
import cn.com.duiba.galaxy.sdk.utils.PageList;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * @author jiaxz
 * @since 2022-12-30
 */
public interface PrizeApi {

    /**
     * 使用发奖策略出奖
     *
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    //  StrategyResult strategyPrize(String prizeStrategyId);

    /**
     * 可以指定一个用户进行策略发奖
     * 注意：如果你得活动是模板活动，那么只能指定发奖规则(StrategyTypeEnum)
     * 如何获取StrategyTypeEnum？？getEnableStrategyType
     *
     * @param userId
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult sendPrizeWithStrategy(String userId, String prizeStrategyId);

    /**
     * 给用户发放道具
     *
     * @param userId   userId
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     */
    Long giveStageProperty(Long userId, String spId, int quantity);

    /**
     * 注意：慎用，quantity传long,避免sp_record sum报错
     * <p>
     * 给用户发放道具
     *
     * @param userId   userId
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     */
    Long giveStageProperty(Long userId, String spId, long quantity);

    /**
     * 消耗某个用户的道具
     *
     * @param userId   userId
     * @param spId     spId
     * @param quantity 数量
     * @return 消耗是否成功
     */
    Boolean consumeStageProperty(Long userId, String spId, int quantity);

    /**
     * 消耗某个用户的道具
     *
     * @param userId   userId
     * @param spId     spId
     * @param quantity 数量
     * @return 消耗是否成功
     */
    Boolean consumeStageProperty(Long userId, String spId, long quantity);

    /**
     * 查询某人所有的道具的数量信息
     *
     * @param userId 需要查询的用户
     * @return key:道具id，value:拥有的道具数
     */
    Map<String, Long> getSomebodyAllStageProperty(Long userId);

    /**
     * 查询某些用户的某个道具数
     *
     * @param userIds 用户id最多支持1000人，超过抛异常
     * @param spId    sp id
     * @return map user id -> sp count
     */
    Map<Long, Long> getSpByUserIds(List<String> userIds, String spId);

    /**
     * 查询某人的某个道具的数量
     *
     * @param userId 需要查询的用户
     * @param spId   道具id
     * @return
     */
    Long getSomebodyStageProperty(Long userId, String spId);




    /**
     * sum sp record
     * 获取扣减的或者增加的总数
     * 只能永久道具使用。
     *
     * @param userId user id
     * @param spId   sp id
     * @param type   + -
     * @return sum
     */
    Long sumSpRecord(Long userId, String spId, String type);

    /**
     * 分页页查询用户道具记录
     * ⚠️ PageSize 不能大于200
     *
     * @param userId
     * @param spId
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageList<UserSpRecordNew> pageQuerySpRecord(Long userId, String spId, long pageNum, long pageSize);

    /**
     * 根据时间范围分页页查询用户道具记录
     * ⚠️ PageSize 不能大于200
     *
     * @param userId
     * @param spId
     * @param pageNum
     * @param pageSize
     * @return
     */
    PageList<UserSpRecordNew> pageQuerySpRecord(Long userId, String spId, long pageNum, long pageSize, LocalDateTime startTime, LocalDateTime endTime);




    /**
     * 根据场景id查询对应的发奖规则
     *
     * @param sceneId
     * @return
     */
    List<String> queryRuIdsBySceneId(String sceneId);


    /**
     * 根据场景id发奖
     *
     * @param sceneId
     * @return
     */
    StrategyResult sendPrizeBySceneId(String sceneId);


    /**
     * 获取启用策略类型
     * 注意:目前只针对模板活动查询已启用的发奖规则
     *
     * @return {@link List}<{@link String}>
     */
    StrategyTypeEnum getEnableStrategyType();
}
