package cn.com.duiba.galaxy.sdk.api.prize.inner;


public interface Option {
    /**
     * 获取 奖项ID
     *
     * @return {@link Long}
     */
    Long getId();

    /**
     * 获取 奖项名称
     *
     * @return {@link String}
     */
    String getName();

    /**
     * 获取 奖项类型
     *
     * @return {@link Integer}
     */
    Integer getType();

    /**
     * 获取 已获得的奖品图片(道具可以为空)
     *
     * @return {@link String}
     */
    String getIcon();

    /**
     * 获取 未获取icon2（针对道具类型）
     *
     * @return {@link String}
     */
    String getIcon2();


    /**
     * 获取 单次发放个数（仅道具）
     *
     * @return {@link Long}
     */
    Long getSendCount();


    /**
     * 获取 是否在首页展示标记（0不展示，1展示）
     *
     * @return {@link Integer}
     */
    Integer getShowIndexType();
}
