package cn.com.duiba.galaxy.sdk.api.tools;

import cn.com.duiba.galaxy.sdk.api.ProjectTransactionApi;
import cn.com.duiba.galaxy.sdk.api.redis.RedisApi;
import cn.com.duiba.galaxy.sdk.api.tools.inner.area.IpAreaData;
import cn.com.duiba.galaxy.sdk.api.tools.inner.area.PhoneAreaData;
import cn.com.duiba.galaxy.sdk.api.tools.inner.lock.LockApi;
import cn.com.duiba.galaxy.sdk.api.tools.inner.logger.BuriedPointService;

import java.util.Map;

/**
 * @author jiaxz
 * @since 2022-12-30
 */
public interface ToolsApi {
    /**
     * 给指定的内容签名
     *
     * @param appId       app id 必传
     * @param signContent 需要签名的内容
     * @return 带签名的map
     */
    Map<String, String> doSign(Long appId, Map<String, String> signContent);

    /**
     * 查询手机号归属地信息
     *
     * @param phone
     * @return
     */
    PhoneAreaData queryPhoneAreaData(String phone);

    /**
     * 获取事务执行API
     *
     * @return projectTransactionApi
     */
    ProjectTransactionApi getTransactionApi();

    /**
     * 埋点api
     * @return
     */
    BuriedPointService getBuriedPointService();

    /**
     * 获取ip及所在地
     *
     * @return
     */
    IpAreaData getIpData(String ip);

    /**
     * 获取RedisAPi
     */
    RedisApi getRedisApi();

    /**
     * 获取锁Api
     * @return
     */
    LockApi getLockApi();
}
