package cn.com.duiba.galaxy.sdk.apiextra;


import cn.com.duiba.galaxy.sdk.api.tools.inner.lock.DistributedLock;
import cn.com.duiba.galaxy.sdk.api.user.inner.ConsumerData;

import java.util.Date;
import java.util.Map;

public interface UserContext {

    Long getUserId();

    /**
     * 查询我所有的道具的数量信息
     *
     * @return key:道具id，value:拥有的道具数
     */
    Map<String, Long> getAllStageProperty();

    /**
     * 查询我的某个道具的数量
     *
     * @param spId
     * @return
     */
    Long getStageProperty(String spId);

    // TODO: 2022/10/19 直接发奖
//    /**
//     * 直接发奖，不通过发奖规则进行发奖
//     *
//     * @param customStrategyId
//     * @param prizeId
//     * @return
//     */
//    boolean sendPrizeWithDirect(String customStrategyId, String prizeId);

    ConsumerData getMyConsumerData();


    /**
     * 记录当前用户的数据
     *
     * @param key
     * @param value
     */
    void putMyData(String key, Object value);


    /**
     * 记录当前用户的数据
     * @param key
     * @param value
     * @param expireTime 过期时间，
     * todo 提供秒数转日期的方法
     */
    void putMyData(String key, Object value, Date expireTime);





    /**
     * 获取当前用户的数据
     * @param key
     * @return
     */
    String getMyData(String key);

    Long getUserDataLong(String key);

    /**
     * 获取当前活动的用户锁，可重入
     * @return
     */
    DistributedLock getMyLock();

}
