package cn.com.duiba.galaxy.sdk.apiextra;

import cn.com.duiba.galaxy.sdk.apiextra.inner.UserData;

import java.util.Date;
import java.util.List;

/**
 * @author jiaxz
 * @since 2023-01-03
 */
public interface UserDataApi {

    /**
     * list user data
     * user id 的个数不能超过500个，超过会抛异常
     *
     * @param key     key
     * @param userIds user ids
     * @return user data listk
     */
    List<UserData> batchListUserData(String key, List<String> userIds);


    /**
     * 添加用户数据
     *
     * @param key
     * @param content
     * @return
     */
    public Long addCustomUserData(String userId, String key, String content, Date expireTime);

    /**
     * 查询用户数据
     *
     * @param userId
     * @param key
     * @return
     */
    public UserData query(String userId, String key, boolean canExpire);


}
