package cn.com.duiba.galaxy.sdk.message;

/**
 * 自定义业务错误信息对象
 * <p>
 * 注意事项：
 * 1、错误码生成规则：错误码 = 场景前缀 + 自定义编码；
 * 2、获取错误码唯一方法为{@link BizError#getCode()}，为保障全平台业务错误码统一管理，请勿重写该方法；
 * 3、创建自定义错误信息枚举时，需要使用者明确的场景类型，如：开发C端活动时，业务场景类型应选择{@link SystemModuleEnum#APP}
 * 4、关于如何通过实现该接口自定义错误枚举类，可参考Demo{@link UnclassifiedStatusEnum}；
 *
 * @author fangxiaorun
 * @date 2022/09/28
 */
public interface BizError {
    /**
     * 获取场景类型
     *
     * @return {@link SystemModuleEnum}
     */
    SystemModuleEnum getBizScene();

    /**
     * 获取自定义编码（错误码通过方法{@link BizError#getCode()}获取）
     *
     * @return {@link String}
     */
    String getNodeCode();

    /**
     * 获取描述信息
     *
     * @return {@link String}
     */
    String getDesc();

    /**
     * 获取错误码
     *
     * @return {@link String}
     */
    default String getCode() {
        return String.format("%s%s", getBizScene().getCode(), getNodeCode());
    }
}