package cn.com.duiba.galaxy.sdk.playway.join.inner;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.playway.PlaywayInterface;

import java.util.List;
import java.util.Map;

/**
 * 参与玩法
 * 业务代码请不要显式实现此类，否则一旦需要添加新方法，线上已有代码会因未实现新方法而报错。
 * 请继承实现此接口的抽象类
 * ⚠️：覆写的方法返回值请务必保持一致，否则无法会被解析为两个方法
 */
public interface JoinPlayway extends PlaywayInterface {

    /**
     * queryMyJoin:查询我的参与信息
     * @param context
     * @param joinUserRequestApi
     * @return
     */
    Map<String, Long> queryMyJoinCount(UserRequestContext context, JoinUserRequestApi joinUserRequestApi);

    /**
     * queryMyJoinRecord:查询我的参与记录
     * @param context
     * @param joinUserRequestApi
     * @return
     */
    List<JoinRecord> queryMyJoinRecord(UserRequestContext context, JoinUserRequestApi joinUserRequestApi);


    /**
     * join:参与
     * @param context
     * @param joinUserRequestApi
     * @return
     */
    Boolean join(UserRequestContext context, JoinUserRequestApi joinUserRequestApi);


}