package cn.com.duiba.galaxy.sdk.api.base;

import cn.com.duiba.galaxy.sdk.api.tools.inner.area.IpAreaData;
import cn.com.duiba.galaxy.common.message.BizError;

import javax.servlet.http.HttpServletRequest;

/**
 * 用户请求参数
 *
 * @author houwen
 */
public interface UserRequestContext extends Api {

    /**
     * HttpServletRequest
     *
     * @return
     */
    HttpServletRequest getHttpRequest();

    Long getUserId();

    /**
     * 获取兑吧用户的DuibaPartnerUserId
     *
     * @return
     */
    String getPartnerUserId();

    String getIp();

    String getUA();

    String getTransfer();

    /**
     * 从请求域中获取绑定好数据的对象
     *
     * @param clazz
     * @param <T>
     * @return
     */
    <T> T bindingDataWithCheck(Class<T> clazz);

    /**
     * 获取用户的请求ip及所在地
     *
     * @return
     */
    IpAreaData getIpData();

    /**
     * 获取 HttpServletRequest 参数
     *
     * @param name  key
     * @param e     异常信息，为null时不处理空或者空字符串
     * @return
     */
    String getStringParameter(String name, BizError e);

    /**
     * 获取 HttpServletRequest 参数
     * <p>
     * 等同于 context.getHttpRequest().getParameter("name")
     * </p>
     *
     * @param name
     * @param def 默认值
     * @return
     */
    String getStringParameter(String name, String def);



    String getStringParameter(String name);


    Integer getIntegerParameter(String name);

    Long getLongParameter(String name);


    Integer getIntegerParameter(String name,Integer def);


    /**
     * 获取和校验参数  检查空值并抛出异常
     * @param name
     * @return
     */
    String getStringParameterCheckBlank(String name);


    String getStringParameterCheckBlank(String name,String errorMsg);


    Integer getIntegerParameterCheckNull(String name);


    Integer getIntegerParameterCheckNull(String name, String errorMsg);



}
