package cn.com.duiba.galaxy.sdk.api.credits.inner;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 扣除积分请求
 *
 * @author fangxiaorun
 * @date 2022/11/10
 */
@Getter
@Setter
public class DeductCreditsRequest implements Serializable {
    /**
     * 积分数
     */
    @Range(min = 0)
    private Long credits;

    /**
     * 玩法id
     */
    @NotBlank
    private String playwayId;

    /**
     * actionId
     */
    @NotBlank
    private String actionId;

    /**
     * 用户ID
     */
    @NotNull
    private Long userId;

    /**
     * 描述
     */
    private String desc;

    /**
     * 来源
     */
    private String transfer;

    /**
     * 用户ip{@link UserRequestApi#getIp()}
     */
    private String ip;
}
