package cn.com.duiba.galaxy.sdk.api.pay.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 银行卡类型
 *
 * @author fangxiaorun
 * @date 2023/01/10
 */
@Getter
@AllArgsConstructor
public enum BankTypeEnum {

    /**
     * 借记卡
     */
    JIEJI_CARD(1, "_DEBIT", "借记卡"),
    /**
     * 信用卡
     */
    CREDITS_CARD(2, "_CREDIT", "信用卡");

    /**
     * 通过bankType获取枚举实例
     *
     * @param bankType 类型
     * @return {@link BankTypeEnum}
     */
    public static BankTypeEnum valueOfBankType(Integer bankType) {
        return Arrays.stream(BankTypeEnum.values()).filter(obj -> Objects.equals(obj.bankType, bankType)).findFirst().orElse(null);
    }


    /**
     * 类型
     */
    private final Integer bankType;

    /**
     * 后缀
     */
    private final String suffix;

    /**
     * 描述
     */
    private final String desc;
}
