package cn.com.duiba.galaxy.sdk.api.pay.third.ali;

import cn.com.duiba.galaxy.sdk.api.pay.param.BasePayReq;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * created by liugq in 2020/03/19
 * 微信支付h5 入参
*/
public class AliWapPayReq extends BasePayReq {

    private static final long serialVersionUID = 7807546397566095817L;

    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "缺少支付金额")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;
    /**
     * 业务方业务id
     */
    @NotNull
    private String bizId;

    @Size(max = 255, message = "returnUrl不能超过255")
    private String returnUrl;
    /**
     * 用户付款中途退出返回商户网站的地址
     */
    @NotNull(message = "quitUrl不能为空")
    @Size(max = 400, message = "quitUrl不能超过400")
    private String quitUrl;
    /**
     * 对一笔交易的具体描述信息。
     */
    @Size(max = 128, message = "body不能超过128")
    private String body;

    private String extra;

    private String notifyUrl;

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getQuitUrl() {
        return quitUrl;
    }

    public void setQuitUrl(String quitUrl) {
        this.quitUrl = quitUrl;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }
}

