package cn.com.duiba.galaxy.sdk.component.drawprize;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.component.base.DrawPrizeQueryResult;
import cn.com.duiba.galaxy.sdk.component.base.PrizeResult;
import cn.com.duiba.galaxy.sdk.component.drawprize.dto.DrawPrizeOptionResult;


/**
 * 抽奖api
 *
 * @author fangxiaorun
 * @date 2023/02/02
 */
public interface DrawPrizeApi extends UserRequestApi {

    /**
     * 查询奖品配置信息
     *
     * @param componentId 组件id
     * @return {@link DrawPrizeOptionResult}
     */
    DrawPrizeOptionResult queryOptions(String componentId);

    /**
     * 查询用户参与抽奖的基础信息
     *
     * @param componentId 组件id
     * @param userId      用户id
     * @return {@link DrawPrizeQueryResult}
     */
    DrawPrizeQueryResult queryUserInfo(String componentId, Long userId);

    /**
     * 抽奖
     *
     * @param componentId 组件id
     * @return {@link PrizeResult}
     */
    PrizeResult drawPrize(String componentId);

    /**
     * 增加次数
     *
     * @param componentId 组件id
     * @param userId      用户ID
     * @param count       次数
     * @return boolean
     */
    boolean addCount(String componentId, Long userId, int count);
}
