package cn.com.duiba.galaxy.sdk.component.drawprize;


import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.component.base.DrawPrizeQueryResult;
import cn.com.duiba.galaxy.sdk.component.base.PrizeResult;

/**
 * 抽奖品组件行动默认实现
 * <p>
 * 注意📢：此处需要自行处理并发问题
 *
 * @author fangxiaorun
 * @date 2023/02/02
 */
public class DrawPrizeComponentActionDefault extends DrawPrizeComponentAction {

    private final String componentId;

    public DrawPrizeComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    /**
     * 查询用户参与抽奖的基础信息
     *
     * @param api api
     * @return {@link DrawPrizeQueryResult}
     */
    @Override
    @CustomRequestAction(id = "queryUserInfo", desc = "查询用户参与抽奖的基础信息")
    public DrawPrizeQueryResult queryUserInfo(DrawPrizeApi api) {
        DrawPrizeApi drawPrizeApi = api.getComponentApi().getDrawPrizeApi();
        return drawPrizeApi.queryUserInfo(componentId, api.getUserId());
    }

    /**
     * 抽奖
     *
     * @param api api
     * @return {@link PrizeResult}
     */
    @Override
    @UserConcurrentLock
    @CustomRequestAction(id = "drawPrize", desc = "抽奖")
    public PrizeResult drawPrize(DrawPrizeApi api) {
        DrawPrizeApi drawPrizeApi = api.getComponentApi().getDrawPrizeApi();
        return drawPrizeApi.drawPrize(componentId);
    }
}
