package cn.com.duiba.galaxy.sdk.component.rank;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.component.rank.dto.RankPrize;

import java.util.List;

/**
 * @author jiaxz
 * @since 2023-01-18
 */
public interface RankApi extends UserRequestApi {


    /**
     * 更新排行榜分数通过增加
     * 更新排行榜分数(在原来的分数基础上递增)
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @param score           分数
     * @throws BizRuntimeException 业务运行时异常
     */
    void updateRankingScoreByIncr(String rankComponentId, Long userId, int score) throws BizRuntimeException;

    /**
     * 更新排行榜分数
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @param score           分数
     * @throws BizRuntimeException 业务运行时异常
     */
    void updateRankingScore(String rankComponentId, Long userId, int score) throws BizRuntimeException;


    /**
     * 获取某个人当前排行榜名次
     *
     * @param userId          用户id
     * @param rankComponentId 排行榜组件id
     * @return {@link Integer}
     */
    Integer getCurrentRanking(String rankComponentId, Long userId);


    /**
     * 获取某人以前排行榜名次
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @return {@link Integer}
     */
    Integer getPreviousRanking(String rankComponentId, Long userId);

    /**
     * 获取当前绑单前n名的排行榜信息
     *
     * @param rankComponentId 排行榜组件id
     * @param topN            topn
     * @return {@link List}<{@link Ranking}>
     */
    List<Ranking> getCurrentTopN(String rankComponentId, int topN);


    /**
     * 获取排行榜信息
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @return {@link Ranking}
     */
    Ranking getCurrentRankInfo(String rankComponentId, Long userId);

    /**
     * 获取以前排行榜信息
     *
     * @param rankComponentId 排行榜组件id
     * @param userId          用户id
     * @return {@link Ranking}
     */
    Ranking getPreviousRankInfo(String rankComponentId, Long userId);


    /**
     * 查询排行榜奖品
     *
     * @param rankComponentId 排行榜组件id
     * @param type            类型
     */
    List<RankPrize> queryRankPrizes(String rankComponentId, String type);


//    List<RankPrize> getCurrentOption();


}
