package cn.com.duiba.galaxy.sdk.component.rank;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.api.prize.PrizeApi;
import cn.com.duiba.galaxy.sdk.component.BaseComponentAction;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinResult;

import java.util.List;

/**
 * @author jiaxz
 * @since 2023-01-18
 */
public abstract class RankComponentAction implements BaseComponentAction {
    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.RANK;
    }

    /**
     * 查询排行榜奖项接口
     * 调用 api.doSign()
     *
     * @param context
     * @return
     */
    @CustomRequestAction(id = "queryOptions", desc = "查询排行榜奖项接口")
    public abstract List<PrizeApi> queryOptions(UserRequestApi context);

    /**
     * 查询排行榜
     * 调用 api.doSign()
     *
     * @param context
     * @return
     */
    @CustomRequestAction(id = "queryRanking", desc = "查询排行榜")
    public abstract Object queryRanking(UserRequestApi context);


    /**
     * 查询当前用户排行榜信息
     * 调用 api.doSign()
     *
     * @param context
     * @return
     */
    @CustomRequestAction(id = "queryUserRanking", desc = "查询当前用户排行榜信息")
    public abstract CheckinResult queryUserRanking(UserRequestApi context);


    /**
     * 查询当前排行榜是否最后一期
     * 调用 api.doSign()
     *
     * @param context
     * @return
     */
    @CustomRequestAction(id = "queryLastPhaseAction", desc = "查询当前排行榜是否最后一期")
    public abstract CheckinResult queryLastPhaseAction(UserRequestApi context);
}
